% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.emdi.R
\name{estimators}
\alias{estimators}
\title{Presents point, MSE and CV estimates}
\usage{
estimators(object, indicator, MSE, CV, ...)
}
\arguments{
\item{object}{an object for which point and/or MSE estimates and/or
calculated CV's are desired.}

\item{indicator}{optional character vector that selects which indicators
shall be returned.}

\item{MSE}{optional logical. If \code{TRUE}, MSE estimates for selected indicators
per domain are added to the data frame of point estimates. Defaults to
\code{FALSE}.}

\item{CV}{optional logical. If \code{TRUE}, coefficients of variation for selected
indicators per domain are added to the data frame of point estimates.
Defaults to \code{FALSE}.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
The return of \code{estimators} depends on the class of its argument. The
documentation of particular methods gives detailed information about the
return of that method.
}
\description{
Function \code{estimators} is a generic function used to present point and
mean squared error (MSE) estimates and calculated coefficients of variation
(CV).
}
