% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{data_transformation}
\alias{data_transformation}
\title{Tranforms dependent variables}
\usage{
data_transformation(fixed, smp_data, transformation, lambda)
}
\arguments{
\item{fixed}{a two-sided linear formula object describing the
fixed-effects part of the nested error linear regression model with the
dependent variable on the left of a ~ operator and the explanatory
variables on the right, separated by + operators. The argument corresponds
to the argument \code{fixed} in function \code{\link[nlme]{lme}}.}

\item{smp_data}{a data frame that needs to comprise all variables named in
\code{fixed}. If transformed data is further used to fit a nested error
linear regression model \code{smp_data} also needs to comprise the variable
named in \code{smp_domains} (see \code{\link{ebp}}).}

\item{transformation}{a character string. Three different transformation
methods for the dependent variable can be chosen (i) no transformation ("no");
(ii) natural log transformation ("log"); (iii) Box-Cox transformation
("box.cox").}

\item{lambda}{a scalar parameter that determines the Box-Cox transformation. 
In case of no and natural log transformation \code{lambda} can be set to NULL.}
}
\value{
a named list with two elements, a data frame containing the data set
with transformed dependent variable (\code{transformed_data}) and a shift 
parameter \code{shift} if present. In case of no transformation the original 
data frame is returned and the shift parameter is NULL.
}
\description{
Function \code{data_transformation} transforms the dependent variable from 
the formula object \code{fixed} in the given sample data set. Thus, it 
returns the original sample data set with transformed dependent variable. 
For the transformation three types can be chosen, particularly no, natural 
log and Box-Cox transformation.
}
\details{
For the natural log and Box-Cox transformation the dependent variable 
is shifted such that all values are greater than zero since the transformations 
are not applicable for values equal to or smaller than zero. The shift is 
calculated as follows: 
  \deqn{shift = |min(y)| + 1 \qquad if \qquad min(y) <= 0}
Function \code{data_transformation} works as a wrapper function. This means
that the function manages the selection of the three different transformation
functions \code{no_transform}, \code{log_transform} and \code{box_cox}.
}
\examples{
# Loading data - sample data
data("eusilcA_smp")

# Transform dependent variable in sample data with Box-Cox transformation
transform_data <- data_transformation(eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, eusilcA_smp, "box.cox", 0.7)
}
\seealso{
\code{\link[nlme]{lme}}
}
