% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.HatchingSuccess.R
\name{plot.HatchingSuccess}
\alias{plot.HatchingSuccess}
\title{Plot results of HatchingSuccess.fit() that best describe hatching success}
\usage{
\method{plot}{HatchingSuccess}(
  x,
  xlim = c(20, 40),
  ylim = c(0, 1),
  xlab = "Constant incubation temperatures",
  ylab = "Hatching success",
  bty = "n",
  las = 1,
  col.observations = "red",
  pch.observations = 19,
  cex.observations = 1,
  show.CI.observations = TRUE,
  col.ML = "black",
  lty.ML = 1,
  lwd.ML = 1,
  col.median = "black",
  lty.median = 2,
  lwd.median = 1,
  col.CI = "black",
  lty.CI = 3,
  lwd.CI = 1,
  replicates = NULL,
  resultmcmc = NULL,
  polygon = TRUE,
  color.polygon = rgb(red = 0.8, green = 0, blue = 0, alpha = 0.1),
  what = c("observations", "ML", "CI"),
  ...
)
}
\arguments{
\item{x}{A result file generated by HatchingSuccess.fit()}

\item{xlim}{Range of temperatures}

\item{ylim}{Hatching success range for y-axis}

\item{xlab}{x label}

\item{ylab}{y label}

\item{bty}{bty graphical parameter}

\item{las}{las graphical parameter}

\item{col.observations}{Color of observations}

\item{pch.observations}{Character used for observation (no observations if NULL)}

\item{cex.observations}{Size of characters for observations}

\item{show.CI.observations}{Should the confidence interval of the observations be shown?}

\item{col.ML}{Color of the maximum likelihood model}

\item{lty.ML}{Line type of the maximum likelihood model (no line if NULL)}

\item{lwd.ML}{Line width of the maximum likelihood model}

\item{col.median}{Color of the median model}

\item{lty.median}{Line type of the median model (no line if NULL)}

\item{lwd.median}{Line width of the mean model}

\item{col.CI}{Color of the 95\% confidence interval lines}

\item{lty.CI}{Line type of the 95\% confidence interval lines (no line if NULL)}

\item{lwd.CI}{Line width of the 95\% confidence interval lines}

\item{replicates}{Number of replicates to estimate confidence interval}

\item{resultmcmc}{Results obtained using HatchingSuccess.MHmcmc()}

\item{polygon}{If TRUE, confidence interval is shown as a polygon}

\item{color.polygon}{The color used for polygon}

\item{what}{Indicate what to plot: "observations", "ML", "CI"}

\item{...}{Parameters for plot()}
}
\value{
Nothing
}
\description{
Plot the estimates that best describe hatching success.\cr
If replicates is 0, it returns only the fitted model.\cr
If replicates is null and resultmcmc is not null, it will use all the mcmc data.\cr
if replicates is lower than the number of iterations in resultmcmc, it will use sequence of data regularly thined.
}
\details{
plot.HatchingSuccess plot result of HatchingSuccess.fit() or HatchingSuccess.MHmcmc() that best describe hatching success
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=0.8)
         
HatchingSuccess.lnL(par=par, data=totalIncubation_Cc)

g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)

HatchingSuccess.lnL(par=g$par, data=totalIncubation_Cc)

plot(g, replicates=0)
plot(g, replicates=10000)

pMCMC <- HatchingSuccess.MHmcmc_p(g, accept=TRUE)
mcmc <- HatchingSuccess.MHmcmc(result=g, parameters = pMCMC, 
                                adaptive=TRUE, n.iter=100000, trace=1000)
plot(g, resultmcmc=mcmc)
plot(g, resultmcmc=mcmc, pch.observations=NULL, lty.mean=NULL)
}
}
\author{
Marc Girondot
}
