% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{elo.mse}
\alias{elo.mse}
\alias{mse}
\alias{brier}
\alias{mse.elo.run}
\alias{mse.elo.glm}
\alias{mse.elo.running}
\alias{mse.elo.markovchain}
\alias{mse.elo.winpct}
\alias{mse.elo.colley}
\title{Calculate the mean square error}
\usage{
mse(object, ..., subset = TRUE)

brier(object, ..., subset = TRUE)

\method{mse}{elo.run}(object, ..., subset = TRUE)

\method{mse}{elo.glm}(object, ..., subset = TRUE)

\method{mse}{elo.running}(object, running = TRUE, discard.skipped = FALSE, ..., subset = TRUE)

\method{mse}{elo.markovchain}(object, ..., subset = TRUE)

\method{mse}{elo.winpct}(object, ..., subset = TRUE)

\method{mse}{elo.colley}(object, ..., subset = TRUE)
}
\arguments{
\item{object}{An object}

\item{...}{Other arguments (not used at this time).}

\item{subset}{(optional) A vector of indices on which to calculate}

\item{running}{logical, denoting whether to use the running predicted values.}

\item{discard.skipped}{Logical, denoting whether to ignore the skipped observations in the calculation}
}
\description{
Calculate the mean square error (Brier score) for a model.
}
\details{
Even though logistic regressions don't use the MSE on the y=0/1 scale, it can still be informative.
  Note that the S3 method is \code{mse}.
}
