% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.markovchain.R
\name{elo.markovchain}
\alias{elo.markovchain}
\title{\code{elo.markovchain}}
\usage{
elo.markovchain(formula, data, family = "binomial", weights, na.action,
  subset, k = NULL, ..., running = FALSE, skip = 0)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{family}{Arguments passed to \code{\link[stats]{glm}}.}

\item{weights}{A vector of weights. Note that these weights are used in the Markov Chain model,
but not the regression.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{The probability that the winning team is better given that they won. See details.}

\item{...}{Arguments passed to \code{\link[stats]{glm}}.}

\item{running}{Logical, denoting whether to calculate "running" projected probabilities. If true, a model is fit for
group 1 on its own to predict group 2, then groups 1 and 2 to predict 3, then groups 1 through 3 to predict 4, etc.
Groups are determined in \code{formula}. Omitting a group term re-runs a glm model to predict each
observation (a potentially time-consuming operation!)}

\item{skip}{Integer, denoting how many groups to skip before fitting the running models. This is helpful if
groups are small, where glm would have trouble converging for the first few groups. The predicted values are then
set to 0.5 for the skipped groups.}
}
\description{
Compute a Markov chain model for a matchup.
}
\details{
See the vignette for details on this method. The probabilities we call 'k' purely for convenience.
  The differences in assigned scores (from the stationary distribution pi) are fed into a logistic
  regression model to predict wins or (usually) a linear model to predict margin of victory.
  It is also possible to adjust the regression by setting the second argument of
   \code{\link{adjust}()}. As in \code{\link{elo.glm}},
  the intercept represents the home-field advantage. Neutral fields can be indicated
  using the \code{\link{neutral}()} function, which sets the intercept to 0.
  See the vignette for more details.

  Note that by assigning probabilities in the right way, this function emits the
  Logistic Regression Markov Chain model (LRMC).
}
\examples{
elo.markovchain(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = tournament,
  subset = points.Home != points.Visitor, k = 0.7)

elo.markovchain(mov(points.Home, points.Visitor) ~ team.Home + team.Visitor, family = "gaussian",
  data = tournament, k = 0.7)
}
\references{
Kvam, P. and Sokol, J.S. A logistic regression/Markov chain model for NCAA basketball.
  Naval Research Logistics. 2006. 53; 788-803.
}
\seealso{
\code{\link[stats]{glm}}, \code{\link{summary.elo.markovchain}}, \code{\link{score}},
  \code{\link{mov}}, \code{\link{elo.model.frame}}
}
