% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{Content}
\alias{Content}
\alias{ContentText}
\alias{ContentImage}
\alias{ContentImageRemote}
\alias{ContentImageInline}
\alias{ContentToolRequest}
\alias{ContentToolResult}
\alias{ContentThinking}
\alias{ContentPDF}
\title{Content types received from and sent to a chatbot}
\usage{
Content()

ContentText(text = stop("Required"))

ContentImage()

ContentImageRemote(url = stop("Required"), detail = "")

ContentImageInline(type = stop("Required"), data = NULL)

ContentToolRequest(
  id = stop("Required"),
  name = stop("Required"),
  arguments = list(),
  tool = NULL
)

ContentToolResult(value = NULL, error = NULL, extra = list(), request = NULL)

ContentThinking(thinking = stop("Required"), extra = list())

ContentPDF(
  type = stop("Required"),
  data = stop("Required"),
  filename = stop("Required")
)
}
\arguments{
\item{text}{A single string.}

\item{url}{URL to a remote image.}

\item{detail}{Not currently used.}

\item{type}{MIME type of the image.}

\item{data}{Base64 encoded image data.}

\item{id}{Tool call id (used to associate a request and a result).
Automatically managed by \pkg{ellmer}.}

\item{name}{Function name}

\item{arguments}{Named list of arguments to call the function with.}

\item{tool}{ellmer automatically matches a tool request to the tools defined
for the chatbot. If \code{NULL}, the request did not match a defined tool.}

\item{value}{The results of calling the tool function, if it succeeded.}

\item{error}{The error message, as a string, or the error condition thrown
as a result of a failure when calling the tool function. Must be \code{NULL}
when the tool call is successful.}

\item{extra}{Additional data.}

\item{request}{The \link{ContentToolRequest} associated with the tool result,
automatically added by \pkg{ellmer} when evaluating the tool call.}

\item{thinking}{The text of the thinking output.}

\item{filename}{File name, used to identify the PDF.}
}
\value{
S7 objects that all inherit from \code{Content}
}
\description{
Use these functions if you're writing a package that extends ellmer and need
to customise methods for various types of content. For normal use, see
\code{\link[=content_image_url]{content_image_url()}} and friends.

ellmer abstracts away differences in the way that different \link{Provider}s
represent various types of content, allowing you to more easily write
code that works with any chatbot. This set of classes represents types of
content that can be either sent to and received from a provider:
\itemize{
\item \code{ContentText}: simple text (often in markdown format). This is the only
type of content that can be streamed live as it's received.
\item \code{ContentImageRemote} and \code{ContentImageInline}: images, either as a pointer
to a remote URL or included inline in the object. See
\code{\link[=content_image_file]{content_image_file()}} and friends for convenient ways to construct these
objects.
\item \code{ContentToolRequest}: a request to perform a tool call (sent by the
assistant).
\item \code{ContentToolResult}: the result of calling the tool (sent by the user).
This object is automatically created from the value returned by calling the
\code{\link[=tool]{tool()}} function. Alternatively, expert users can return a
\code{ContentToolResult} from a \code{\link[=tool]{tool()}} function to include additional data or
to customize the display of the result.
}
}
\examples{
Content()
ContentText("Tell me a joke")
ContentImageRemote("https://www.r-project.org/Rlogo.png")
ContentToolRequest(id = "abc", name = "mean", arguments = list(x = 1:5))
}
