% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/live.R
\name{live_console}
\alias{live_console}
\alias{live_browser}
\title{Open a live chat application}
\usage{
live_console(chat, quiet = FALSE)

live_browser(chat, quiet = FALSE)
}
\arguments{
\item{chat}{A chat object created by \code{\link[=chat_openai]{chat_openai()}} or friends.}

\item{quiet}{If \code{TRUE}, suppresses the initial message that explains how
to use the console.}
}
\value{
(Invisibly) The input \code{chat}.
}
\description{
\itemize{
\item \code{live_console()} lets you chat interactively in the console.
\item \code{live_browser()} lets you chat interactively in a browser.
}

Note that these functions will mutate the input \code{chat} object as
you chat because your turns will be appended to the history.
}
\examples{
\dontrun{
chat <- chat_anthropic()
live_console(chat)
live_browser(chat)
}
}
