% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlt.R
\name{mlt}
\alias{mlt}
\title{More like this request.}
\usage{
mlt(index, type, id, doc_type = NULL, body = NULL, boost_terms = NULL,
  include = NULL, max_doc_freq = NULL, max_query_terms = NULL,
  max_word_length = NULL, min_doc_freq = NULL, min_term_freq = NULL,
  min_word_length = NULL, mlt_fields = NULL,
  percent_terms_to_match = NULL, routing = NULL, search_from = NULL,
  search_indices = NULL, search_query_hint = NULL, search_scroll = NULL,
  search_size = NULL, search_source = NULL, search_type = NULL,
  search_types = NULL, stop_words = NULL, like_text = NULL, ...)
}
\arguments{
\item{index}{The name of the index}

\item{type}{A document type}

\item{id}{The document ID}

\item{doc_type}{The type of the document (use _all to fetch the first document matching the ID
across all types)}

\item{body}{A specific search request definition}

\item{boost_terms}{The boost factor}

\item{include}{Whether to include the queried document from the response}

\item{max_doc_freq}{The word occurrence frequency as count: words with higher occurrence in the
corpus will be ignored}

\item{max_query_terms}{The maximum query terms to be included in the generated query}

\item{max_word_length}{The minimum length of the word: longer words will be ignored}

\item{min_doc_freq}{The word occurrence frequency as count: words with lower occurrence in the
corpus will be ignored}

\item{min_term_freq}{The term frequency as percent: terms with lower occurence in the source
document will be ignored}

\item{min_word_length}{The minimum length of the word: shorter words will be ignored}

\item{mlt_fields}{Specific fields to perform the query against}

\item{percent_terms_to_match}{How many terms have to match in order to consider the document a
match (default: 0.3)}

\item{routing}{Specific routing value}

\item{search_from}{The offset from which to return results}

\item{search_indices}{A comma-separated list of indices to perform the query against (default:
the index containing the document)}

\item{search_query_hint}{The search query hint}

\item{search_scroll}{A scroll search request definition}

\item{search_size}{The number of documents to return (default: 10)}

\item{search_source}{A specific search request definition (instead of using the request body)}

\item{search_type}{Specific search type (eg. dfs_then_fetch, count, etc)}

\item{search_types}{A comma-separated list of types to perform the query against (default: the
same type as the document)}

\item{stop_words}{A list of stop words to be ignored}

\item{like_text}{Like text...}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
More like this request.
}
\details{
Currently uses HTTP GET request, so parameters are passed in the URL. Another option
is the "more like this query", which passes the query in the body of a POST request - may
be added later.
}
\examples{
\dontrun{
mlt(index = "plos", type = "article", id = 5)$hits$total
mlt(index = "plos", type = "article", id = 5, min_doc_freq=12)$hits$total
mlt(index = "plos", type = "article", id = 800)$hits$total

# Return different number of results
mlt(index = "plos", type = "article", id = 800, search_size=1)$hits$hits
mlt(index = "plos", type = "article", id = 800, search_size=2)$hits$hits

# Exclude stop words
mlt(index = "plos", type = "article", id = 800)$hits$total
mlt(index = "plos", type = "article", id = 800, stop_words="the,and")$hits$total

# Specify percent of terms that have to match
mlt(index = "plos", type = "article", id = 800, percent_terms_to_match=0.1)$hits$total
mlt(index = "plos", type = "article", id = 800, percent_terms_to_match=0.7)$hits$total

# Maximum query terms to be included in the generated query
mlt(index = "plos", type = "article", id = 800, max_query_terms=1)$hits$total
mlt(index = "plos", type = "article", id = 800, max_query_terms=2)$hits$total
mlt(index = "plos", type = "article", id = 800, max_query_terms=3)$hits$total

# Maximum query terms to be included in the generated query
mlt(index = "plos", type = "article", id = 800, mlt_fields="title", boost_terms=1)$hits$total
}
}

