% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_analysis.R
\name{performance_analysis}
\alias{performance_analysis}
\title{Performs a performance analysis using a voter file, census shape, and
district shape.}
\usage{
performance_analysis(
  voter_file,
  district_shape,
  census_shape,
  census_data,
  join_census_shape = TRUE,
  join_district_shape = TRUE,
  state = NULL,
  voter_id = "voter_id",
  surname = "last_name",
  district = "district",
  census_state_col = "STATEFP10",
  census_county_col = "COUNTYFP10",
  census_tract_col = "TRACTCE10",
  census_block_col = "BLOCKCE10",
  crs = NULL,
  coords = c("lon", "lat"),
  census_geo = "block",
  use_surname = TRUE,
  surname_only = FALSE,
  surname_year = 2010,
  use_age = FALSE,
  use_sex = FALSE,
  normalize = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{voter_file}{A dataframe containing the voter file.}

\item{district_shape}{The shapefiles for the new districts or precincts to
consider.}

\item{census_shape}{The shapefiles for the Census blocks or tracts for which
the voter file will be geocoded against.}

\item{census_data}{A dataframe containing the Census tracts or blocks in the
region for the voter file.}

\item{join_census_shape}{A logical denoting whether the voter file already
has the Census block, tract, and county information. If TRUE, then column
names for these items must be provided. If FALSE, then a Census shape must
be provided in order to perform a spatial join.}

\item{join_district_shape}{A logical denoting whether the voter file already
has the district identity per voter. If TRUE, then a column names for the
district must be provided. If FALSE, then a distrct shape must be provided
in order to perform a spatial join.}

\item{state}{The state in which the functionality analysis is performed, as
a two character string.}

\item{voter_id}{A string denoting the column name for the voter ID.}

\item{surname}{A string denoting the column name for the surname.}

\item{district}{A string denoting the column name for the district.}

\item{census_state_col}{The column in the Census data that indicates state.
If the voter file already has Census information, this should denote the
column in the voter file containing the state FIPS code.}

\item{census_county_col}{The column in the Census data that indicates county.
If the voter file already has Census information, this should denote the
column in the voter file containing the county FIPS code.}

\item{census_tract_col}{The column in the Census data that indicates tract.
If the voter file already has Census information, this should denote the
column in the voter file containing the tract FIPS code.}

\item{census_block_col}{The column in the Census data that indicates block.
If the voter file already has Census information, this should denote the
column in the voter file containing the block FIPS code.}

\item{crs}{A string denoting the PROJ4 string for projecting maps.}

\item{coords}{The columns for the coordinates.}

\item{census_geo}{The geographic level at which to perform BISG.}

\item{use_surname}{Whether to use the surname in calculating race
probabilities. Passed to WRU.}

\item{surname_only}{Whether to only use the surname in calculating race
probabilities. Passed to WRU.}

\item{surname_year}{Which Census year to use for surname matching. Passed to
WRU.}

\item{use_age}{Whether to use the age in the BISG calculation. Passed to WRU.}

\item{use_sex}{Whether to use the sex in the BISG calculation. Passed to WRU.}

\item{normalize}{If TRUE, normalizes the district percentages.}

\item{verbose}{If TRUE, will output diagnostic strings.}
}
\value{
The processed voter file and a summary of district turnout across
  racial groups.
}
\description{
Performs a performance analysis using a voter file, census shape, and
district shape.
}
