% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ehelp.R
\name{ehelp}
\alias{ehelp}
\title{Enhanced-Help Function: ehelp()
This function displays docstring style comments used as help liners for user
defined functions.}
\usage{
ehelp(
  fun,
  fn.name = as.character(substitute(fun)),
  coloring = FALSE,
  output = "none"
)
}
\arguments{
\item{fun}{function name of an user-defined function}

\item{coloring}{a Boolean flag indicating whether to use colors for displaying messages}

\item{output}{specify if the documentation generated by the ehelp() will be saved in a file, possible values are "txt" (for help only), "TXT" (for help and full fn body) or "none" (default, for in screen display only)}

\item{fn}{name of the function (string)}
}
\description{
Enhanced-Help Function: ehelp()
This function displays docstring style comments used as help liners for user
defined functions.
}
\examples{
myTestFn <- function(x,y,z,t=0) {
#'
#' This is just an example of a dummy fn
#'
#'
#' @email myemail@somewhere.org
#' @author author
#
#
#' @demo
#' @examples myTestFn(x0,y0,z0)
}

ehelp(myTestFn)

## this requires the "crayon" package to work
ehelp(myTestFn, coloring=TRUE)

## generation of documentation for a fn in different formats
## by indicating a particular format, ehelp will save in a file
## the corresponding documentation of the selected fn
## Valid formats are:
## 		txt (plain-text), ascii (text with ESC-codes for coloring),
## 		latex, html, markdown
## Additionally, capitalized versions of these formats, will also include
## the listing of the fn

\dontrun{
ehelp(myTestFn, output="latex")
ehelp(myTestFn, output="TXT")
ehelp(myTestFn, coloring=TRUE, output="HTML")
ehelp(myTestFn, coloring=TRUE, output="ASCII")
ehelp(myTestFn, coloring=TRUE, output="markdown")
}
}
\keyword{internal}
