% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lognormal.R
\name{Lognormal}
\alias{Lognormal}
\alias{hlnorm}
\alias{Lnorm}
\alias{dlnorm}
\alias{plnorm}
\alias{qlnorm}
\alias{Hlnorm}
\alias{rlnorm}
\title{The Lognormal Distribution}
\usage{
hlnorm(x, meanlog = 0, sdlog = 1, shape = 1 / sdlog, scale = exp(meanlog),
prop = 1, log = FALSE) 
Hlnorm(x, meanlog = 0, sdlog = 1, shape = 1 / sdlog, scale = exp(meanlog), 
prop = 1, log.p = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{meanlog}{mean in the Normal distribution.}

\item{sdlog, shape}{sdlog is standard deviation in the Normal distrimution, 
shape = 1/sdlog.}

\item{scale}{is exp(meanlog).}

\item{prop}{proportionality constant in the extended Lognormal distribution.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
\code{dlnorm} gives the density, \code{plnorm} gives the distribution
function, \code{qlnorm} gives the quantile function, \code{hlnorm} gives the
hazard function, \code{Hlnorm} gives the cumulative hazard function, and
\code{rlnorm} generates random deviates.

Invalid arguments will result in return value \code{NaN}, with a warning.
}
\description{
Density, distribution function, quantile function, hazard function,
cumulative hazard function, and random generation for the Lognormal distribution
with parameters \code{shape} and \code{scale}.
}
\details{
The Lognormal distribution with \code{scale} parameter \eqn{a} and \code{shape}
parameter \eqn{\sigma}{b} has hazard function given by \deqn{h(x) =
(b/\sigma)(x/\sigma)^(b-1)\exp((x / \sigma)^b)}{% h(x) =
(b/a)(x/a)^(b-1)exp((x / a)^b)} for \eqn{x \ge 0}{x >= 0}.
}
\keyword{distribution}
