% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpchreg.R
\name{tpchreg}
\alias{tpchreg}
\title{Proportional hazards regression with piecewise constant hazards and tabular 
data.}
\usage{
tpchreg(formula, data, time, weights, last, subset, na.action, 
contrasts = NULL, start.coef = NULL, 
control = list(epsilon = 1.e-8, maxit = 200, trace = FALSE))
}
\arguments{
\item{formula}{a formula with 'oe(count, exposure) ~ x1 + ...'}

\item{data}{a data frame with occurrence/exposure data plus covariates.}

\item{time}{the time variable, a factor character vector indicating time 
intervals, or numeric, indicating the start of intervals.}

\item{weights}{Case weights.}

\item{last}{If \code{time} is numeric, the closing of the last interval.}

\item{subset}{subset of data, not implemented yet.}

\item{na.action}{Not implemented yet.}

\item{contrasts}{Not implemented yet.}

\item{start.coef}{For the moment equal to zero, not used.}

\item{control}{list of control parameters for the optimization.}
}
\description{
Proportional hazards regression with piecewise constant hazards and tabular 
data.
}
\note{
The interpretation of cuts is different from that in \code{\link{hpch}}.
This is intentional.
}
\examples{

sw <- swepop
sw$deaths <- swedeaths$deaths
fit <- tpchreg(oe(deaths, pop) ~ strata(sex) + I(year - 2000), 
time = age, last = 101, data = sw[sw$year >= 2000, ])
summary(fit)

}
\seealso{
\code{\link{oe}}.
}
\keyword{regression}
\keyword{survival}
\keyword{table}
