/*
    This file is part of rstanarm.
    Copyright (C) 2015, 2016 Trustees of Columbia University
    
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_indefficacy_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_indefficacy");
    reader.add_event(35, 33, "end", "model_indefficacy");
    return reader;
}

class model_indefficacy : public prob_grad {
private:
    int J;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_indefficacy(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_indefficacy(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_indefficacy_namespace::model_indefficacy";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("ystararaw", "J", J);
            context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(J));
            validate_non_negative_index("ystararaw", "J", J);
            ystararaw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystararaw");
            pos__ = 0;
            size_t ystararaw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
                ystararaw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("ystarbraw", "J", J);
            context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(J));
            validate_non_negative_index("ystarbraw", "J", J);
            ystarbraw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystarbraw");
            pos__ = 0;
            size_t ystarbraw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
                ystarbraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("fpre", "J", J);
            context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(J));
            validate_non_negative_index("fpre", "J", J);
            fpre = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpre");
            pos__ = 0;
            size_t fpre_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
                fpre[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("fpost", "J", J);
            context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(J));
            validate_non_negative_index("fpost", "J", J);
            fpost = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpost");
            pos__ = 0;
            size_t fpost_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
                fpost[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 9;
            ++num_params_r__;
            current_statement_begin__ = 10;
            ++num_params_r__;
            current_statement_begin__ = 11;
            validate_non_negative_index("delta", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 12;
            ++num_params_r__;
            current_statement_begin__ = 13;
            ++num_params_r__;
            current_statement_begin__ = 14;
            validate_non_negative_index("mub", "J", J);
            num_params_r__ += J;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_indefficacy() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        validate_non_negative_index("delta", "J", J);
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(J));
        std::vector<double> delta(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("delta_shape")))
            throw std::runtime_error("variable delta_shape missing");
        vals_r__ = context__.vals_r("delta_shape");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta_shape", "double", context__.to_vec());
        double delta_shape(0);
        delta_shape = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,delta_shape);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta_shape: ") + e.what());
        }

        if (!(context__.contains_r("delta_mu")))
            throw std::runtime_error("variable delta_mu missing");
        vals_r__ = context__.vals_r("delta_mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta_mu", "double", context__.to_vec());
        double delta_mu(0);
        delta_mu = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta_mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta_mu: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        validate_non_negative_index("mub", "J", J);
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(J));
        std::vector<double> mub(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0,lp__);
            else
                kappa = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);

            vector<local_scalar_t__> delta;
            size_t dim_delta_0__ = J;
            delta.reserve(dim_delta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
                if (jacobian__)
                    delta.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    delta.push_back(in__.scalar_lb_constrain(0));
            }

            local_scalar_t__ delta_shape;
            (void) delta_shape;  // dummy to suppress unused var warning
            if (jacobian__)
                delta_shape = in__.scalar_lb_constrain(0,lp__);
            else
                delta_shape = in__.scalar_lb_constrain(0);

            local_scalar_t__ delta_mu;
            (void) delta_mu;  // dummy to suppress unused var warning
            if (jacobian__)
                delta_mu = in__.scalar_lub_constrain(0,1,lp__);
            else
                delta_mu = in__.scalar_lub_constrain(0,1);

            vector<local_scalar_t__> mub;
            size_t dim_mub_0__ = J;
            mub.reserve(dim_mub_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
                if (jacobian__)
                    mub.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mub.push_back(in__.scalar_lb_constrain(0));
            }


            // transformed parameters
            current_statement_begin__ = 17;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 18;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 19;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 20;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 21;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((get_base1(delta,i,"delta",1) * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdaa[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdab[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 17;
            current_statement_begin__ = 18;

            // model body

            current_statement_begin__ = 25;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 26;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 27;
            lp_accum__.add(gamma_log<propto__>(delta, delta_shape, (delta_shape / delta_mu)));
            current_statement_begin__ = 28;
            lp_accum__.add(normal_log<propto__>(delta_shape, 2, 1));
            current_statement_begin__ = 29;
            lp_accum__.add(beta_log<propto__>(delta_mu, 1, 1));
            current_statement_begin__ = 30;
            lp_accum__.add(gamma_log<propto__>(mub, kappa, (kappa / mu)));
            current_statement_begin__ = 31;
            lp_accum__.add(poisson_log<propto__>(ystararaw, lambdaa));
            current_statement_begin__ = 32;
            lp_accum__.add(poisson_log<propto__>(ystarbraw, lambdab));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("delta_shape");
        names__.push_back("delta_mu");
        names__.push_back("mub");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_indefficacy_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        vector<double> delta;
        size_t dim_delta_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_lb_constrain(0));
        }
        double delta_shape = in__.scalar_lb_constrain(0);
        double delta_mu = in__.scalar_lub_constrain(0,1);
        vector<double> mub;
        size_t dim_mub_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(kappa);
        vars__.push_back(mu);
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
        vars__.push_back(delta_shape);
        vars__.push_back(delta_mu);
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mub[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 17;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 18;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 19;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 20;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 21;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((get_base1(delta,i,"delta",1) * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            current_statement_begin__ = 17;
            current_statement_begin__ = 18;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_indefficacy";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta_shape";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta_mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta_shape";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta_mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_nb_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_nb");
    reader.add_event(24, 22, "end", "model_nb");
    return reader;
}

class model_nb : public prob_grad {
private:
    int J;
    vector<int> ystarraw;
    vector<int> CF;
public:
    model_nb(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_nb(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_nb_namespace::model_nb";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("ystarraw", "J", J);
            context__.validate_dims("data initialization", "ystarraw", "int", context__.to_vec(J));
            validate_non_negative_index("ystarraw", "J", J);
            ystarraw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystarraw");
            pos__ = 0;
            size_t ystarraw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystarraw_limit_0__; ++i_0__) {
                ystarraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("CF", "J", J);
            context__.validate_dims("data initialization", "CF", "int", context__.to_vec(J));
            validate_non_negative_index("CF", "J", J);
            CF = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("CF");
            pos__ = 0;
            size_t CF_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < CF_limit_0__; ++i_0__) {
                CF[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 7;
            ++num_params_r__;
            current_statement_begin__ = 8;
            ++num_params_r__;
            current_statement_begin__ = 9;
            validate_non_negative_index("mui", "J", J);
            num_params_r__ += J;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_nb() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("mui")))
            throw std::runtime_error("variable mui missing");
        vals_r__ = context__.vals_r("mui");
        pos__ = 0U;
        validate_non_negative_index("mui", "J", J);
        context__.validate_dims("initialization", "mui", "double", context__.to_vec(J));
        std::vector<double> mui(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mui[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mui[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mui: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0,lp__);
            else
                kappa = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);

            vector<local_scalar_t__> mui;
            size_t dim_mui_0__ = J;
            mui.reserve(dim_mui_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
                if (jacobian__)
                    mui.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mui.push_back(in__.scalar_lb_constrain(0));
            }


            // transformed parameters
            current_statement_begin__ = 12;
            validate_non_negative_index("lambda", "J", J);
            vector<local_scalar_t__> lambda(J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);


            current_statement_begin__ = 13;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 14;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)), 
                            "assigning variable lambda");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambda[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 12;

            // model body

            current_statement_begin__ = 18;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 19;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 20;
            lp_accum__.add(gamma_log<propto__>(mui, kappa, (kappa / mu)));
            current_statement_begin__ = 21;
            lp_accum__.add(poisson_log<propto__>(ystarraw, lambda));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("mui");
        names__.push_back("lambda");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_nb_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        vector<double> mui;
        size_t dim_mui_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
            mui.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(kappa);
        vars__.push_back(mu);
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mui[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 12;
            validate_non_negative_index("lambda", "J", J);
            vector<local_scalar_t__> lambda(J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);


            current_statement_begin__ = 13;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 14;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)), 
                            "assigning variable lambda");
            }

            // validate transformed parameters
            current_statement_begin__ = 12;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_nb";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_paired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_paired");
    reader.add_event(32, 30, "end", "model_paired");
    return reader;
}

class model_paired : public prob_grad {
private:
    int J;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_paired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_paired(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_paired_namespace::model_paired";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("ystararaw", "J", J);
            context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(J));
            validate_non_negative_index("ystararaw", "J", J);
            ystararaw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystararaw");
            pos__ = 0;
            size_t ystararaw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
                ystararaw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("ystarbraw", "J", J);
            context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(J));
            validate_non_negative_index("ystarbraw", "J", J);
            ystarbraw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystarbraw");
            pos__ = 0;
            size_t ystarbraw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
                ystarbraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("fpre", "J", J);
            context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(J));
            validate_non_negative_index("fpre", "J", J);
            fpre = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpre");
            pos__ = 0;
            size_t fpre_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
                fpre[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("fpost", "J", J);
            context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(J));
            validate_non_negative_index("fpost", "J", J);
            fpost = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpost");
            pos__ = 0;
            size_t fpost_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
                fpost[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 9;
            ++num_params_r__;
            current_statement_begin__ = 10;
            ++num_params_r__;
            current_statement_begin__ = 11;
            ++num_params_r__;
            current_statement_begin__ = 12;
            validate_non_negative_index("mub", "J", J);
            num_params_r__ += J;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_paired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        validate_non_negative_index("mub", "J", J);
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(J));
        std::vector<double> mub(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0,lp__);
            else
                kappa = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);

            local_scalar_t__ delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.scalar_lub_constrain(0,1,lp__);
            else
                delta = in__.scalar_lub_constrain(0,1);

            vector<local_scalar_t__> mub;
            size_t dim_mub_0__ = J;
            mub.reserve(dim_mub_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
                if (jacobian__)
                    mub.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mub.push_back(in__.scalar_lb_constrain(0));
            }


            // transformed parameters
            current_statement_begin__ = 15;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 16;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 17;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 18;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 19;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdaa[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdab[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 15;
            current_statement_begin__ = 16;

            // model body

            current_statement_begin__ = 23;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 24;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 25;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 26;
            lp_accum__.add(gamma_log<propto__>(mub, kappa, (kappa / mu)));
            current_statement_begin__ = 27;
            lp_accum__.add(poisson_log<propto__>(ystararaw, lambdaa));
            current_statement_begin__ = 28;
            lp_accum__.add(poisson_log<propto__>(ystarbraw, lambdab));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mub");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_paired_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mub;
        size_t dim_mub_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mub[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 15;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 16;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 17;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 18;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 19;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            current_statement_begin__ = 15;
            current_statement_begin__ = 16;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_paired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_simple_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_simple");
    reader.add_event(30, 28, "end", "model_simple");
    return reader;
}

class model_simple : public prob_grad {
private:
    int J;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_simple(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_simple(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_simple_namespace::model_simple";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("ystararaw", "J", J);
            context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(J));
            validate_non_negative_index("ystararaw", "J", J);
            ystararaw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystararaw");
            pos__ = 0;
            size_t ystararaw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
                ystararaw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("ystarbraw", "J", J);
            context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(J));
            validate_non_negative_index("ystarbraw", "J", J);
            ystarbraw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystarbraw");
            pos__ = 0;
            size_t ystarbraw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
                ystarbraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("fpre", "J", J);
            context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(J));
            validate_non_negative_index("fpre", "J", J);
            fpre = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpre");
            pos__ = 0;
            size_t fpre_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
                fpre[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("fpost", "J", J);
            context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(J));
            validate_non_negative_index("fpost", "J", J);
            fpost = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpost");
            pos__ = 0;
            size_t fpost_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
                fpost[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 10;
            ++num_params_r__;
            current_statement_begin__ = 11;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_simple() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.scalar_lub_constrain(0,1,lp__);
            else
                delta = in__.scalar_lub_constrain(0,1);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);


            // transformed parameters
            current_statement_begin__ = 15;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 16;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 17;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 18;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (mu / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 19;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * mu) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdaa[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdab[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 15;
            current_statement_begin__ = 16;

            // model body

            current_statement_begin__ = 24;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 25;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 26;
            lp_accum__.add(poisson_log<propto__>(ystararaw, lambdaa));
            current_statement_begin__ = 27;
            lp_accum__.add(poisson_log<propto__>(ystarbraw, lambdab));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("delta");
        names__.push_back("mu");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_simple_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double delta = in__.scalar_lub_constrain(0,1);
        double mu = in__.scalar_lb_constrain(0);
        vars__.push_back(delta);
        vars__.push_back(mu);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 15;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 16;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 17;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 18;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (mu / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 19;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * mu) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            current_statement_begin__ = 15;
            current_statement_begin__ = 16;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_simple";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_unpaired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_unpaired");
    reader.add_event(36, 34, "end", "model_unpaired");
    return reader;
}

class model_unpaired : public prob_grad {
private:
    int Ja;
    int Jb;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_unpaired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_unpaired(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_unpaired_namespace::model_unpaired";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "Ja", "int", context__.to_vec());
            Ja = int(0);
            vals_i__ = context__.vals_i("Ja");
            pos__ = 0;
            Ja = vals_i__[pos__++];
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "Jb", "int", context__.to_vec());
            Jb = int(0);
            vals_i__ = context__.vals_i("Jb");
            pos__ = 0;
            Jb = vals_i__[pos__++];
            current_statement_begin__ = 4;
            validate_non_negative_index("ystararaw", "Ja", Ja);
            context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(Ja));
            validate_non_negative_index("ystararaw", "Ja", Ja);
            ystararaw = std::vector<int>(Ja,int(0));
            vals_i__ = context__.vals_i("ystararaw");
            pos__ = 0;
            size_t ystararaw_limit_0__ = Ja;
            for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
                ystararaw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("ystarbraw", "Jb", Jb);
            context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(Jb));
            validate_non_negative_index("ystarbraw", "Jb", Jb);
            ystarbraw = std::vector<int>(Jb,int(0));
            vals_i__ = context__.vals_i("ystarbraw");
            pos__ = 0;
            size_t ystarbraw_limit_0__ = Jb;
            for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
                ystarbraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("fpre", "Ja", Ja);
            context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(Ja));
            validate_non_negative_index("fpre", "Ja", Ja);
            fpre = std::vector<int>(Ja,int(0));
            vals_i__ = context__.vals_i("fpre");
            pos__ = 0;
            size_t fpre_limit_0__ = Ja;
            for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
                fpre[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("fpost", "Jb", Jb);
            context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(Jb));
            validate_non_negative_index("fpost", "Jb", Jb);
            fpost = std::vector<int>(Jb,int(0));
            vals_i__ = context__.vals_i("fpost");
            pos__ = 0;
            size_t fpost_limit_0__ = Jb;
            for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
                fpost[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            current_statement_begin__ = 7;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 10;
            ++num_params_r__;
            current_statement_begin__ = 11;
            ++num_params_r__;
            current_statement_begin__ = 12;
            ++num_params_r__;
            current_statement_begin__ = 13;
            validate_non_negative_index("mub", "Jb", Jb);
            num_params_r__ += Jb;
            current_statement_begin__ = 14;
            validate_non_negative_index("mua", "Ja", Ja);
            num_params_r__ += Ja;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_unpaired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        validate_non_negative_index("mub", "Jb", Jb);
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(Jb));
        std::vector<double> mub(Jb,double(0));
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        if (!(context__.contains_r("mua")))
            throw std::runtime_error("variable mua missing");
        vals_r__ = context__.vals_r("mua");
        pos__ = 0U;
        validate_non_negative_index("mua", "Ja", Ja);
        context__.validate_dims("initialization", "mua", "double", context__.to_vec(Ja));
        std::vector<double> mua(Ja,double(0));
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            mua[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mua[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mua: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0,lp__);
            else
                kappa = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);

            local_scalar_t__ delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.scalar_lub_constrain(0,1,lp__);
            else
                delta = in__.scalar_lub_constrain(0,1);

            vector<local_scalar_t__> mub;
            size_t dim_mub_0__ = Jb;
            mub.reserve(dim_mub_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
                if (jacobian__)
                    mub.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mub.push_back(in__.scalar_lb_constrain(0));
            }

            vector<local_scalar_t__> mua;
            size_t dim_mua_0__ = Ja;
            mua.reserve(dim_mua_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
                if (jacobian__)
                    mua.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mua.push_back(in__.scalar_lb_constrain(0));
            }


            // transformed parameters
            current_statement_begin__ = 17;
            validate_non_negative_index("lambdaa", "Ja", Ja);
            vector<local_scalar_t__> lambdaa(Ja);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 18;
            validate_non_negative_index("lambdab", "Jb", Jb);
            vector<local_scalar_t__> lambdab(Jb);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 19;
            for (int i = 1; i <= Jb; ++i) {

                current_statement_begin__ = 20;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
            }
            current_statement_begin__ = 22;
            for (int i = 1; i <= Ja; ++i) {

                current_statement_begin__ = 23;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < Ja; ++i0__) {
                if (stan::math::is_uninitialized(lambdaa[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < Jb; ++i0__) {
                if (stan::math::is_uninitialized(lambdab[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 17;
            current_statement_begin__ = 18;

            // model body

            current_statement_begin__ = 27;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 28;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 29;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 30;
            lp_accum__.add(gamma_log<propto__>(mub, kappa, (kappa / mu)));
            current_statement_begin__ = 31;
            lp_accum__.add(gamma_log<propto__>(mua, kappa, (kappa / mu)));
            current_statement_begin__ = 32;
            lp_accum__.add(poisson_log<propto__>(ystarbraw, lambdab));
            current_statement_begin__ = 33;
            lp_accum__.add(poisson_log<propto__>(ystararaw, lambdaa));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mub");
        names__.push_back("mua");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_unpaired_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mub;
        size_t dim_mub_0__ = Jb;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> mua;
        size_t dim_mua_0__ = Ja;
        for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
            mua.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
            for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(mub[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(mua[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 17;
            validate_non_negative_index("lambdaa", "Ja", Ja);
            vector<local_scalar_t__> lambdaa(Ja);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 18;
            validate_non_negative_index("lambdab", "Jb", Jb);
            vector<local_scalar_t__> lambdab(Jb);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 19;
            for (int i = 1; i <= Jb; ++i) {

                current_statement_begin__ = 20;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
            }
            current_statement_begin__ = 22;
            for (int i = 1; i <= Ja; ++i) {

                current_statement_begin__ = 23;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            current_statement_begin__ = 17;
            current_statement_begin__ = 18;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_unpaired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_zinb_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_zinb");
    reader.add_event(31, 29, "end", "model_zinb");
    return reader;
}

class model_zinb : public prob_grad {
private:
    int J;
    vector<int> ystarraw;
    vector<int> CF;
public:
    model_zinb(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_zinb(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_zinb_namespace::model_zinb";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("ystarraw", "J", J);
            context__.validate_dims("data initialization", "ystarraw", "int", context__.to_vec(J));
            validate_non_negative_index("ystarraw", "J", J);
            ystarraw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystarraw");
            pos__ = 0;
            size_t ystarraw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystarraw_limit_0__; ++i_0__) {
                ystarraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("CF", "J", J);
            context__.validate_dims("data initialization", "CF", "int", context__.to_vec(J));
            validate_non_negative_index("CF", "J", J);
            CF = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("CF");
            pos__ = 0;
            size_t CF_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < CF_limit_0__; ++i_0__) {
                CF[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 7;
            ++num_params_r__;
            current_statement_begin__ = 8;
            ++num_params_r__;
            current_statement_begin__ = 9;
            validate_non_negative_index("mui", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 10;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_zinb() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("mui")))
            throw std::runtime_error("variable mui missing");
        vals_r__ = context__.vals_r("mui");
        pos__ = 0U;
        validate_non_negative_index("mui", "J", J);
        context__.validate_dims("initialization", "mui", "double", context__.to_vec(J));
        std::vector<double> mui(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mui[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mui[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mui: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0,lp__);
            else
                kappa = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);

            vector<local_scalar_t__> mui;
            size_t dim_mui_0__ = J;
            mui.reserve(dim_mui_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
                if (jacobian__)
                    mui.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mui.push_back(in__.scalar_lb_constrain(0));
            }

            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lub_constrain(0,1,lp__);
            else
                phi = in__.scalar_lub_constrain(0,1);


            // transformed parameters
            current_statement_begin__ = 13;
            validate_non_negative_index("lambda", "J", J);
            vector<local_scalar_t__> lambda(J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);


            current_statement_begin__ = 14;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 15;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)), 
                            "assigning variable lambda");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambda[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 13;

            // model body

            current_statement_begin__ = 19;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 20;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 21;
            lp_accum__.add(beta_log<propto__>(phi, 1, 1));
            current_statement_begin__ = 22;
            lp_accum__.add(gamma_log<propto__>(mui, kappa, (kappa / mu)));
            current_statement_begin__ = 23;
            for (int n = 1; n <= J; ++n) {

                current_statement_begin__ = 24;
                if (as_bool(logical_eq(get_base1(ystarraw,n,"ystarraw",1),0))) {
                    current_statement_begin__ = 25;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystarraw,n,"ystarraw",1),get_base1(lambda,n,"lambda",1)))));
                } else {
                    current_statement_begin__ = 27;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystarraw,n,"ystarraw",1),get_base1(lambda,n,"lambda",1))));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("mui");
        names__.push_back("phi");
        names__.push_back("lambda");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_zinb_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        vector<double> mui;
        size_t dim_mui_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
            mui.push_back(in__.scalar_lb_constrain(0));
        }
        double phi = in__.scalar_lub_constrain(0,1);
        vars__.push_back(kappa);
        vars__.push_back(mu);
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mui[k_0__]);
            }
        vars__.push_back(phi);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 13;
            validate_non_negative_index("lambda", "J", J);
            vector<local_scalar_t__> lambda(J);
            stan::math::initialize(lambda, DUMMY_VAR__);
            stan::math::fill(lambda,DUMMY_VAR__);


            current_statement_begin__ = 14;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 15;
                stan::model::assign(lambda, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)), 
                            "assigning variable lambda");
            }

            // validate transformed parameters
            current_statement_begin__ = 13;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_zinb";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_zipaired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_zipaired");
    reader.add_event(44, 42, "end", "model_zipaired");
    return reader;
}

class model_zipaired : public prob_grad {
private:
    int J;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_zipaired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_zipaired(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_zipaired_namespace::model_zipaired";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 3;
            validate_non_negative_index("ystararaw", "J", J);
            context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(J));
            validate_non_negative_index("ystararaw", "J", J);
            ystararaw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystararaw");
            pos__ = 0;
            size_t ystararaw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
                ystararaw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("ystarbraw", "J", J);
            context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(J));
            validate_non_negative_index("ystarbraw", "J", J);
            ystarbraw = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("ystarbraw");
            pos__ = 0;
            size_t ystarbraw_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
                ystarbraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("fpre", "J", J);
            context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(J));
            validate_non_negative_index("fpre", "J", J);
            fpre = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpre");
            pos__ = 0;
            size_t fpre_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
                fpre[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("fpost", "J", J);
            context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(J));
            validate_non_negative_index("fpost", "J", J);
            fpost = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("fpost");
            pos__ = 0;
            size_t fpost_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
                fpost[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 9;
            ++num_params_r__;
            current_statement_begin__ = 10;
            ++num_params_r__;
            current_statement_begin__ = 11;
            ++num_params_r__;
            current_statement_begin__ = 12;
            validate_non_negative_index("mub", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 13;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_zipaired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        validate_non_negative_index("mub", "J", J);
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(J));
        std::vector<double> mub(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0,lp__);
            else
                kappa = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);

            local_scalar_t__ delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.scalar_lub_constrain(0,1,lp__);
            else
                delta = in__.scalar_lub_constrain(0,1);

            vector<local_scalar_t__> mub;
            size_t dim_mub_0__ = J;
            mub.reserve(dim_mub_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
                if (jacobian__)
                    mub.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mub.push_back(in__.scalar_lb_constrain(0));
            }

            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lub_constrain(0,1,lp__);
            else
                phi = in__.scalar_lub_constrain(0,1);


            // transformed parameters
            current_statement_begin__ = 16;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 17;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 18;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 19;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 20;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdaa[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < J; ++i0__) {
                if (stan::math::is_uninitialized(lambdab[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 16;
            current_statement_begin__ = 17;

            // model body

            current_statement_begin__ = 24;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 25;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 26;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 27;
            lp_accum__.add(beta_log<propto__>(phi, 1, 1));
            current_statement_begin__ = 28;
            lp_accum__.add(gamma_log<propto__>(mub, kappa, (kappa / mu)));
            current_statement_begin__ = 29;
            for (int n = 1; n <= J; ++n) {

                current_statement_begin__ = 30;
                if (as_bool(logical_eq(get_base1(ystarbraw,n,"ystarbraw",1),0))) {
                    current_statement_begin__ = 31;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1)))));
                } else {
                    current_statement_begin__ = 33;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1))));
                }
            }
            current_statement_begin__ = 35;
            for (int n = 1; n <= J; ++n) {

                current_statement_begin__ = 36;
                if (as_bool(logical_eq(get_base1(ystararaw,n,"ystararaw",1),0))) {
                    current_statement_begin__ = 37;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1)))));
                } else {
                    current_statement_begin__ = 39;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1))));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mub");
        names__.push_back("phi");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_zipaired_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mub;
        size_t dim_mub_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        double phi = in__.scalar_lub_constrain(0,1);
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mub[k_0__]);
            }
        vars__.push_back(phi);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 16;
            validate_non_negative_index("lambdaa", "J", J);
            vector<local_scalar_t__> lambdaa(J);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 17;
            validate_non_negative_index("lambdab", "J", J);
            vector<local_scalar_t__> lambdab(J);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 18;
            for (int i = 1; i <= J; ++i) {

                current_statement_begin__ = 19;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
                current_statement_begin__ = 20;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            current_statement_begin__ = 16;
            current_statement_begin__ = 17;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_zipaired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_ziunpaired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_ziunpaired");
    reader.add_event(49, 47, "end", "model_ziunpaired");
    return reader;
}

class model_ziunpaired : public prob_grad {
private:
    int Ja;
    int Jb;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpost;
    vector<int> fpre;
public:
    model_ziunpaired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_ziunpaired(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_ziunpaired_namespace::model_ziunpaired";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "Ja", "int", context__.to_vec());
            Ja = int(0);
            vals_i__ = context__.vals_i("Ja");
            pos__ = 0;
            Ja = vals_i__[pos__++];
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "Jb", "int", context__.to_vec());
            Jb = int(0);
            vals_i__ = context__.vals_i("Jb");
            pos__ = 0;
            Jb = vals_i__[pos__++];
            current_statement_begin__ = 4;
            validate_non_negative_index("ystararaw", "Ja", Ja);
            context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(Ja));
            validate_non_negative_index("ystararaw", "Ja", Ja);
            ystararaw = std::vector<int>(Ja,int(0));
            vals_i__ = context__.vals_i("ystararaw");
            pos__ = 0;
            size_t ystararaw_limit_0__ = Ja;
            for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
                ystararaw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            validate_non_negative_index("ystarbraw", "Jb", Jb);
            context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(Jb));
            validate_non_negative_index("ystarbraw", "Jb", Jb);
            ystarbraw = std::vector<int>(Jb,int(0));
            vals_i__ = context__.vals_i("ystarbraw");
            pos__ = 0;
            size_t ystarbraw_limit_0__ = Jb;
            for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
                ystarbraw[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("fpost", "Ja", Ja);
            context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(Ja));
            validate_non_negative_index("fpost", "Ja", Ja);
            fpost = std::vector<int>(Ja,int(0));
            vals_i__ = context__.vals_i("fpost");
            pos__ = 0;
            size_t fpost_limit_0__ = Ja;
            for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
                fpost[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("fpre", "Jb", Jb);
            context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(Jb));
            validate_non_negative_index("fpre", "Jb", Jb);
            fpre = std::vector<int>(Jb,int(0));
            vals_i__ = context__.vals_i("fpre");
            pos__ = 0;
            size_t fpre_limit_0__ = Jb;
            for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
                fpre[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            current_statement_begin__ = 2;
            current_statement_begin__ = 3;
            current_statement_begin__ = 4;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            current_statement_begin__ = 7;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 10;
            ++num_params_r__;
            current_statement_begin__ = 11;
            ++num_params_r__;
            current_statement_begin__ = 12;
            ++num_params_r__;
            current_statement_begin__ = 13;
            validate_non_negative_index("mua", "Ja", Ja);
            num_params_r__ += Ja;
            current_statement_begin__ = 14;
            validate_non_negative_index("mub", "Jb", Jb);
            num_params_r__ += Jb;
            current_statement_begin__ = 15;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_ziunpaired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mua")))
            throw std::runtime_error("variable mua missing");
        vals_r__ = context__.vals_r("mua");
        pos__ = 0U;
        validate_non_negative_index("mua", "Ja", Ja);
        context__.validate_dims("initialization", "mua", "double", context__.to_vec(Ja));
        std::vector<double> mua(Ja,double(0));
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            mua[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mua[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mua: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        validate_non_negative_index("mub", "Jb", Jb);
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(Jb));
        std::vector<double> mub(Jb,double(0));
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ kappa;
            (void) kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                kappa = in__.scalar_lb_constrain(0,lp__);
            else
                kappa = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_lb_constrain(0,lp__);
            else
                mu = in__.scalar_lb_constrain(0);

            local_scalar_t__ delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.scalar_lub_constrain(0,1,lp__);
            else
                delta = in__.scalar_lub_constrain(0,1);

            vector<local_scalar_t__> mua;
            size_t dim_mua_0__ = Ja;
            mua.reserve(dim_mua_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
                if (jacobian__)
                    mua.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mua.push_back(in__.scalar_lb_constrain(0));
            }

            vector<local_scalar_t__> mub;
            size_t dim_mub_0__ = Jb;
            mub.reserve(dim_mub_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
                if (jacobian__)
                    mub.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    mub.push_back(in__.scalar_lb_constrain(0));
            }

            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.scalar_lub_constrain(0,1,lp__);
            else
                phi = in__.scalar_lub_constrain(0,1);


            // transformed parameters
            current_statement_begin__ = 18;
            validate_non_negative_index("lambdaa", "Ja", Ja);
            vector<local_scalar_t__> lambdaa(Ja);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 19;
            validate_non_negative_index("lambdab", "Jb", Jb);
            vector<local_scalar_t__> lambdab(Jb);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 20;
            for (int i = 1; i <= Jb; ++i) {

                current_statement_begin__ = 21;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
            }
            current_statement_begin__ = 23;
            for (int i = 1; i <= Ja; ++i) {

                current_statement_begin__ = 24;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < Ja; ++i0__) {
                if (stan::math::is_uninitialized(lambdaa[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < Jb; ++i0__) {
                if (stan::math::is_uninitialized(lambdab[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 18;
            current_statement_begin__ = 19;

            // model body

            current_statement_begin__ = 28;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 29;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 30;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 31;
            lp_accum__.add(beta_log<propto__>(phi, 1, 1));
            current_statement_begin__ = 33;
            lp_accum__.add(gamma_log<propto__>(mub, kappa, (kappa / mu)));
            current_statement_begin__ = 34;
            lp_accum__.add(gamma_log<propto__>(mua, kappa, (kappa / mu)));
            current_statement_begin__ = 35;
            for (int n = 1; n <= Jb; ++n) {

                current_statement_begin__ = 36;
                if (as_bool(logical_eq(get_base1(ystarbraw,n,"ystarbraw",1),0))) {
                    current_statement_begin__ = 37;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1)))));
                } else {
                    current_statement_begin__ = 39;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1))));
                }
            }
            current_statement_begin__ = 41;
            for (int n = 1; n <= Ja; ++n) {

                current_statement_begin__ = 42;
                if (as_bool(logical_eq(get_base1(ystararaw,n,"ystararaw",1),0))) {
                    current_statement_begin__ = 43;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1)))));
                } else {
                    current_statement_begin__ = 45;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1))));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mua");
        names__.push_back("mub");
        names__.push_back("phi");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_ziunpaired_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mua;
        size_t dim_mua_0__ = Ja;
        for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
            mua.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> mub;
        size_t dim_mub_0__ = Jb;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        double phi = in__.scalar_lub_constrain(0,1);
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
            for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(mua[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(mub[k_0__]);
            }
        vars__.push_back(phi);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 18;
            validate_non_negative_index("lambdaa", "Ja", Ja);
            vector<local_scalar_t__> lambdaa(Ja);
            stan::math::initialize(lambdaa, DUMMY_VAR__);
            stan::math::fill(lambdaa,DUMMY_VAR__);
            current_statement_begin__ = 19;
            validate_non_negative_index("lambdab", "Jb", Jb);
            vector<local_scalar_t__> lambdab(Jb);
            stan::math::initialize(lambdab, DUMMY_VAR__);
            stan::math::fill(lambdab,DUMMY_VAR__);


            current_statement_begin__ = 20;
            for (int i = 1; i <= Jb; ++i) {

                current_statement_begin__ = 21;
                stan::model::assign(lambdab, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)), 
                            "assigning variable lambdab");
            }
            current_statement_begin__ = 23;
            for (int i = 1; i <= Ja; ++i) {

                current_statement_begin__ = 24;
                stan::model::assign(lambdaa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)), 
                            "assigning variable lambdaa");
            }

            // validate transformed parameters
            current_statement_begin__ = 18;
            current_statement_begin__ = 19;

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ziunpaired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdaa" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambdab" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}




#endif
