% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eglm.R
\name{eglm}
\alias{eglm}
\title{Fitting Generalized Linear Models}
\usage{
eglm(
  formula,
  data,
  family = gaussian(),
  intercept = TRUE,
  weights = NULL,
  na.action = na.omit,
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = NULL,
  maxit = 25,
  k = 2,
  model = TRUE,
  singularity.method = c("eigen", "Cholesky", "qr"),
  x = FALSE,
  y = TRUE,
  tol.estimation = 1e-08,
  tol.solve = .Machine$double.eps,
  tol.values = 1e-07,
  tol.vectors = 1e-07,
  ...
)
}
\arguments{
\item{formula}{A formula for the model}

\item{data}{A tibble or data.frame}

\item{family}{See the function \link{glm}, but here it must be specified with brackets (e.g. \code{quasipoisson()})}

\item{intercept}{Logical value to determine wheareas to included an intercept in the null model (Defaults to \code{TRUE})}

\item{weights}{An optional vector of ‘prior weights’ to be used in the fitting process. Should be \code{NULL}
or a numeric vector (e.g. \code{data$weights}, defaults to \code{NULL})}

\item{na.action}{a function which indicates what should happen when the data
contain NAs. The default is set by the \code{na.action} setting of options,
and is \link{na.fail} if that is unset. The ‘factory-fresh’ default is
\code{na.omit}. Another possible value is NULL, no action. Value
\code{na.exclude} can be useful.}

\item{start}{Starting values for the parameters in the linear predictor}

\item{etastart}{Starting values for the linear predictor}

\item{mustart}{Starting values for the vector of means}

\item{offset}{This can be used to specify an a priori known component to be included in the
linear predictor during fitting. This should be \code{NULL} or a numeric vector of length
equal to the number of cases. One or more offset terms can be included in the formula instead
or as well, and if more than one is specified their sum is used. See \code{stats::model.offset()}}

\item{maxit}{See the function \link{glm}}

\item{k}{The penalty per parameter to be used, the default \code{k = 2}
is the classical AIC}

\item{model}{A logical value indicating whether model frame should be included as a
component of the returned value (Defaults to \code{TRUE})}

\item{singularity.method}{The chosen method to detect for singularity. Defaults to \code{"eigen"} but
it can also be \code{"Cholesky"} or \code{"qr"}}

\item{x}{Logical value indicating whether the model matrix used in the fitting process
should be returned as components of the returned value (Defaults to \code{FALSE}, see the function \link{glm.fit})}

\item{y}{Logical value indicating whether the response vector used in the fitting process
should be returned as components of the returned value (Defaults to \code{FALSE}, see the function \link{glm.fit})}

\item{tol.estimation}{Tolerance to be used for the estimation (Defaults to 1e-8)}

\item{tol.solve}{(Defaults to \code{.Machine$double.eps}, see the function \link{solve})}

\item{tol.values}{Tolerance to consider eigenvalues equal to zero (Defaults to 1e-7, see the function \link{control}),}

\item{tol.vectors}{Tolerance to consider eigenvectors equal to zero (Defaults to 1e-7, see the function \link{control})}

\item{\dots}{For eglm: arguments to be used to form the default control argument if it is not supplied directly. For weights: further arguments passed to or from other methods.}
}
\value{
An object of class "eglm" that behaves the same way as the "glm" class, see the function \link{glm}.
}
\description{
eglm is used to fit generalized linear models in an equivalent way to
\code{glm} but in a reduced time depending on the design matrix (see the
DESCRIPTION).
}
\examples{
# Generalized linear model with Gaussian link
eglm(mpg ~ wt, family = gaussian(), data = mtcars)
}
