% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eefAnalytics_03_2017.r
\name{mstFREQ}
\alias{mstFREQ}
\title{Analysis of Multisite Randomised Education Trials using Multilevel Model.}
\usage{
mstFREQ(formula, random, intervention, nPerm = NULL, data, nBoot = NULL)
}
\arguments{
\item{formula}{the model to be analysed. It is of the form y ~ x1+x2+.... Where y is the outcome variable and Xs are the predictors.}

\item{random}{a string variable specifying the "clustering variable" as contained in the data. See example below}

\item{intervention}{a string variable specifying the "intervention variable" as appeared in the formula. See example below}

\item{nPerm}{number of permutations required to generate permutated p-value.  Default is NULL.}

\item{data}{data frame containing the data to be analysed.}

\item{nBoot}{number of bootstraps required to generate bootstrap confidence interval. Default is NULL.}
}
\value{
S3 object; a list consisting of
\itemize{
\item \code{Beta}. Estimates and confidence intervals for preditors specified in the model.
\item \code{ES}. Hedges' g effect size for the intervention(s). If nBoot is not specified, the confidence intervals are 95% CIs based on standard errors. If nBoot is specified, they are non-parametric bootstrapped confidence intervals.
\item \code{covParm}. Vector of variance decomposition into between cluster variance (Schools), clustering by intervention interacttion (Intervention:School) and within cluster variance (Pupils). It also contains the intral-cluster correlation (ICC).
\item \code{SchEffects}. Random intercepts for clusters, e.g schools.
\item \code{Perm}. A "nPerm x w" matrix containing permutated effect sizes using residual variance and total variance. "w" denotes number of intervention. "w=1" for two arm trial and "w=2" for three arm trial excluding the control group. It is produced only when \code{nPerm} is specified.
\item \code{Bootstrap}. A "w x nBoot" matrix containing the bootstrapped effect sizes using residual variance (Within) and total variance (Total). "w=1" for two arm trial and "w=2" for three arm trial excluding the control group. It is only prduced when \code{nBoot} is specified.
}
}
\description{
\code{mstFREQ} performs analysis of multisite randomised education trial using multilevel model within the frequentist framework.
}
\examples{
if(interactive()){

data(mstData)

########################################################
## MLM analysis of multisite trials + 1.96SE ##
########################################################

output1 <- mstFREQ(Posttest~ Intervention+Prettest,random="School",
		intervention="Intervention",data=mstData)


### Fixed effects
beta <- output1$Beta
beta

### Effect size
ES1 <- output1$ES
ES1

## Covariance matrix
covParm <- output1$covParm
covParm

### plot random effects for schools

plot(output1)

###############################################
## MLM analysis of multisite trials          ##	 
## with bootstrap confidence intervals       ##
###############################################

output2 <- mstFREQ(Posttest~ Intervention+Prettest,random="School",
		intervention="Intervention",nBoot=1000,data=mstData)

tp <- output2$Bootstrap
### Effect size

ES2 <- output2$ES
ES2

### plot bootstrapped values 

plot(output2, group=1)

#######################################################################
## MLM analysis of mutltisite trials with permutation p-value##
#######################################################################

output3 <- mstFREQ(Posttest~ Intervention+Prettest,random="School",
		intervention="Intervention",nPerm=1000,data=mstData)

ES3 <- output3$ES
ES3

#### plot permutated values 

plot(output3, group=1)
}
}

