% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createWM.R
\name{createWM}
\alias{createWM}
\title{Create empty weight matrix based on a set of cues and outcomes.}
\usage{
createWM(cues, outcomes, background = NULL, init.value = 0)
}
\arguments{
\item{cues}{A vector with cues.}

\item{outcomes}{A vector with outcomes.}

\item{background}{A string specifying the background cue. Sets this as the 
value of the background cue for all functions in this R session. If NULL, 
the current value of the background cue will be used.}

\item{init.value}{Initial value for all connections, typically set to 0.}
}
\value{
A weightmatrix (matrix)
}
\description{
Create empty weight matrix based on a set of cues and outcomes.
}
\examples{

# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)

# the function RWlearning uses createWM to construct a weight matrix: 
cues <- getValues(dat$Cues, unique=TRUE)
outcomes <- getValues(dat$Outcomes, unique=TRUE)
createWM(cues=cues, outcomes=outcomes)
# add background cue:
createWM(cues=cues, outcomes=outcomes, background=TRUE)

}
\seealso{
\code{link{RWlearning}}
}
\author{
Jacolien van Rij
}
