library(testthat)

test_that("Checking a data set works",{
   edt <- editmatrix(editrules = "2*x==y")
   dat <- data.frame(x=c(2,1), y=c(4,5))
   #print(checkEdits(dat, edt)) 
   expect_equal(checkRows(edt, dat), c(TRUE,FALSE))
})


test_that("Showing data errors works",{
   edt <- editmatrix(editrules = "2*x==y\n5*x==y")
   dat <- data.frame(x=c(2,1), y=c(4,5))
   errors <- errorMatrix(edt, dat)
   
   # rule names equal?
   expect_equal(colnames(errors), rownames(edt))
   
   dimnames(errors) <- NULL
   expect_equal(errors, matrix( c( FALSE, TRUE
                                 , TRUE , FALSE
                                 )
                              , nrow=2
                              , byrow=TRUE
                              
                              )
               )   
})


test_that("Error lists works",{
   edt <- editmatrix(editrules = "2*x==y\n5*x==y")
   dat <- data.frame(x=c(2,1), y=c(4,5))
   errors <- listErrors(edt, dat)
   #expect_equal(errors, list("1"=c(2), "2"=c(1)))
   #print(str(errors))
   #print(showErrors(dat, edt)) 
})