% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_activity.R
\name{filter_activity}
\alias{filter_activity}
\alias{filter_activity.eventlog}
\alias{filter_activity.grouped_eventlog}
\alias{ifilter_activity}
\title{Filter: Activity}
\usage{
filter_activity(eventlog, activities, reverse, ...)

\method{filter_activity}{eventlog}(eventlog, activities, reverse = FALSE, ...)

\method{filter_activity}{grouped_eventlog}(eventlog, activities,
  reverse = FALSE, ...)

ifilter_activity(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{activities}{Character vector containing one or more activity identifiers.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}

\item{...}{Deprecated arguments.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters the log based on activities
}
\details{
The method filter_activity can be used to filter on activity identifiers. It has an activities argument,
to which a vector of identifiers can be given. The selection can be negated with the reverse argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter eventlog for activity labels

\item \code{grouped_eventlog}: Filter grouped eventlog for activity labels
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
