% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_neighbor_map.R
\name{sd_neighbor_map}
\alias{sd_neighbor_map}
\title{A function to create a map of a school district and its neighbors}
\usage{
sd_neighbor_map(data_year = "2019", school_district = NULL,
 map_var = "Student Poverty", legend= TRUE, type = "like")
}
\arguments{
\item{data_year}{Four digit year of master data to pull in. Options include
2013- 2019. Defaults to 2019.}

\item{school_district}{Seven digit NCESID of the school district. Default is
NULL.}

\item{map_var}{Variable by which to symbolize the map.
\itemize{
\item {\code{Student Poverty} colors by student poverty rate}
  \item {\code{Total Revenue} colors by state and local revenue per pupil}
  \item{ \code{Local Revenue} colors by local revenue per pupil}
  \item {\code{State Revenue} colors by state revenue per pupil}
  \item {\code{Percent Nonwhite} colors by percent nonwhite enrollment}
  \item {\code{Median Household Income} colors by owner-occupied median household income}
 \item {\code{Median Property Value} colors by median property value}
  \item {\code{FRL} colors by free and reduced price lunch rate}
  }
  Defaults to \code{Student Poverty}}

\item{legend}{If TRUE, legend is visible. Defaults to TRUE.}

\item{type}{Indicate which types of neighbors to return.
Defaults to "like", returning a map of neighbors of the same
district type (unified to unified, elementary to elementary and
secondary to secondary). To view all neighbors use "all". This
becomes important for districts like Chicago which have upwards of 50
neighboring school districts, but only 1 type-like neighbor.
Chicago is a unified district with 1 unified neighbor,
16 secondary neighbors, and 32 elementary neighbors.}
}
\value{
An image of the map which can be written out with
  \code{tmap::tmap_save(map, '~/Documents/map.png')}
}
\description{
This function allows you to create a map of any school
  district with its neighbors symbolized by a selected variable.
}
\examples{
\donttest{map <- sd_neighbor_map(data_year = "2019", school_district = "2901000", "Percent Nonwhite")}
}
\seealso{
\code{\link{sd_map}}
}
\keyword{EdBuild}
\keyword{map}
\keyword{neighbors}
