% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominates.R
\name{plotFront}
\alias{plotFront}
\title{Plot Pareto-front.}
\usage{
plotFront(x, obj.names = NULL, minimize = TRUE)
}
\arguments{
\item{x}{[\code{matrix} | \code{data.frame}]\cr
Object which contains the non-dominated points.}

\item{obj.names}{[\code{character}]\cr
Optional objectives names.
Default is \code{c("f1", "f2")}.}

\item{minimize}{[\code{logical}]\cr
Logical vector with ith entry \code{TRUE} if the ith objective shall be minimized.
If a single logical is passed, it is assumed to be valid for each objective.
If the matrix is of type \code{ecr_fitness_matrix} (this is the case if it is
produced by one of ecr2's utility functions, e.g. \code{\link{evaluateFitness}}),
the appended \code{minimize} attribute is the default.}
}
\value{
[\code{ggplot}] \pkg{ggplot} object.
}
\description{
Plots a scatterplot of non-dominated points in the objective space
utilizing the \pkg{ggplot2} package. The function returns a \code{ggplot} object
which can be furhter modified via additional ggplot layers.
If the passed object is a \code{data.frame}, each line is considered to contain
the fitness values of one individual. Contrary, if a matrix is passed, it is
considered to be passed in ecr2 format, i.e., each column corresponds to one
point. The matrix is then transposed and converted to a \code{data.frame}.
}
\note{
At the moment only two-dimensional objective spaces are supported.
}
\examples{
matrix
}
