% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_model.R
\name{generate_null_net}
\alias{generate_null_net}
\title{Null models for ecological networks}
\usage{
generate_null_net(consumers, resources, sims = 100, data.type = "names",
  maintain.d = NULL, summary.type = "sum", c.samples = NULL,
  r.samples = NULL, r.weights = NULL, prog.count = TRUE)
}
\arguments{
\item{consumers}{A matrix or data frame containing the interaction data. The
first column should contain the name of the consumer species, with the
remaining column names listing the resources (the names must be identical
and in the same order as in \code{resources}).  Each row represents one
individual, with the elements in the matrix indicating whether a resource
was used or how much was used (see Details).}

\item{resources}{A matrix or data frame containing the relative abundances of
the different resources (e.g. density of different prey species or abundance
of different flower species).  May either have one row, if all data came
from the same location and/or time, or have the same number of rows as
there are sampling stratum codes in \code{r.samples} and \code{c.samples}
(e.g. the set of time points or plot names), if the data are subdivided
across sampling times/sites. Resource names (column names) in
\code{resources} and \code{consumers} must be identical and in the same
order.}

\item{sims}{Number of iterations of the null model.  The default value is 100,
but this should generally be increased to estimate meaningful confidence
limits.}

\item{data.type}{An optional string specifying the type of interaction data.
One of three options: \code{"names"} (the default), \code{"counts"} or
\code{"quantities"}. See Details for a full explanation and examples.}

\item{maintain.d}{When \code{data.type = "counts"} or \code{"quantities"},
a string indicating whether the degree of each individual consumer (i.e.
the number of different resource species it interacted with) should be
maintained when allocating individual resources/quantities. Default is FALSE.}

\item{summary.type}{An optional string indicating how the interactions should
be summarised at the species level: one of \code{"sum"} (the default),
indicating that the interactions between a consumer and resource species
will be summed across all individuals, or \code{"mean"}, indicating that
the mean value per individual of a consumer species will be calculated.}

\item{c.samples}{An optional vector that specifies names for subdivisions of the
interaction data when data on interactions and resource abundance were
collected across a series of subdivisions (e.g. at different sites or time
points). If suddivisions were present, they should be specified for both
\code{c.samples} and \code{r.samples}.  The sample names must be identical
in \code{c.samples} and \code{r.samples} (although \code{c.samples} is likely to
be much longer than \code{r.samples} due to >1 individual consumer per
subdivision)}

\item{r.samples}{An optional vector specifying the sample names for the
resource abundance data (\code{resources}), and corresponding to the names
used in \code{c.samples}. Must have the name number of entries as there are
rows in \code{resources}. Not needed when \code{resources} contains a single
row/\code{c.samples} is absent.}

\item{r.weights}{An optional data frame or matrix specifying weights to be
applied to rows in \code{resources}: all entries must be in the range 0--1.
The first column should contain the consumer species names, one entry for
each species, within the remaining columns listing all species present in
\code{resources} (names must be identical and in the same order as in
\code{resources}).  Mainly used to specify forbidden links by specifying
zero values for forbidden links and ones for the remaining entries.  Only
one table is supplied, which then applies across all subdivisions of the
data (if present).}

\item{prog.count}{A logical value specifying whether the progress count
should be shown. Defaults to \code{TRUE}.}
}
\value{
Returns an object of class "nullnet", which is a list containing
 the following components:
 \describe{
   \item{\code{rand.data}}{Data frame containing the results from all of the
     iterations of the null model}
   \item{\code{obs.interactions}}{Interaction matrix summarising the observed
     interactions (from \code{consumers})}
   \item{\code{n.iterations}}{The value of \code{sims} i.e. the number of
     interations of the null model}
 }
}
\description{
Uses the algorithm of Agusti \emph{et al}. (2003) to specify and run a null
  model for an ecological network based upon interaction data and
  independent estimates of resource abundance (see Vaughan \emph{et al}.,
  in press for full details).  Typically, network nodes represent species,
  and the following documentation uses the term species in place of node,
  but this need not be the case.
}
\details{
A basic call to \code{generate_null_net} only needs two arguments:
  \code{consumers} and \code{resources}, but it is recommended that
  \code{sims} is also specified to run a larger number of iteration of the
  null model (e.g. 1000).  It is important to ensure that species names are
  consistent throughout and that the resource species used as column names in
  \code{resources}, \code{consumers} and (optionally) \code{r.weights} are in
   the same order (both \code{consumers} and \code{r.weights} should be one
  column wider than \code{resources}, because they include an extra column
  at the start to list the consumer species).

  The same species can appear as both a consumer and a resource e.g. when a
  species is both predator and prey in a food web.  Interactions can be
  excluded from the modelled networks by specifying forbidden links with
  \code{r.weights}, based either on existing data/literature or hypothesed
  choices, generating the network that would be created if those choices were
  made.  Placing limits on the feasible range of resources with which a
  consumer interacts should lead to more realistic networks: great white
  sharks not feeding on zooplankton in a marine food web, for example.

  The interactions between individual consumers and the resources may be
  recorded in a range of different ways depending upon the empirical data
  that are available, and these differences are handled by using the
  optional \code{data.type} argument.  Three types of data can be specified:
  \enumerate{
    \item \code{data.type = "names"} (the default value). This is the most
    common type of data, recording one or more resource species with which
    an interaction occurred, but without any attempt to quantify the
    strength of the interaction.  For data of this type, \code{resources}
    should simply comprise 1s and 0s, indicating whether an interaction was
    present or absent respectively: row sums may equal one or be >1 if
    individual consumers can interact with multiple resources.
    \item \code{data.type = "counts"}.  These data record the number of times
    an individual consumer interacted with different resource species e.g.
    the number of times different flower species were visited by an
    individual pollinator during a 5 minute observation period.  When
    modelling count data there is a choice of whether the total number of
    interactions (an individual's row sum) can be distributed across all
    potential resources, which may result in interactions with a different
    number of resource species (i.e. a change in an individual's degree) or
    whether the degree is held constant for each individual.  This is
    determined by the additional \code{maintain.d} argument:
    \code{maintain.d = FALSE} (the default) does not constrain an
    individual's degree, whereas \code{maintain = TRUE} does.
    \item \code{data.type = "quantities"}. Quantitative data are obtained
    from each individual, such as the proportion of a predator's gut
    contents derived from different prey.  The data in \code{consumers} can
    be represented by either proportions (so that the row sum for an
    individual = 1) or in the native units (so the total <> 1). As for count
    data, the degree can be free or fixed at the individual consumer level
    by using the \code{maintain.d} argument.
  }
 For data types 2 and 3, it does not matter what units are used (e.g. each
 row does not need to add up to one).  The row total will be maintained,
 so the results are returned in the same units as the original data.

 One problem that may arise in specifying the null model is in situations
 where an interaction is recorded with a particular resource, but that
 resource was not actually detected in the abundance data (i.e. abundance =
 0).  This may occur, for example, when a predator eats a rare species that
 was missed during concomitant sampling of prey abundance: in effect, the
 predator's 'sampling' was more comprehensive.  The implication of this is
 that the resource species will not be sampled in the null model -- a
 potential source of bias.  \code{generate_null_net} will issue a warning if
 it detects this situation.  Possible corrective actions include removing
 that resource species altogether or replacing its zero abundance with a
 small constant.
}
\examples{
null.1 <- generate_null_net(Silene[, 2:7], Silene.plants[, 2:6], sims = 10,
  data.type = "names", summary.type = "sum", c.samples = Silene[, 1],
  r.samples = Silene.plants[, 1])

}
\references{
Agusti, N., Shayler, S.P., Harwood, J.D., Vaughan, I.P.,
  Sunderland, K.D. & Symondson, W.O.C. (2003) Collembola as alternative prey
  sustaining spiders in arable ecosystems: prey detection within predators
  using molecular markers. \emph{Molecular Ecology}, \strong{12}, 3467--3475.

  King, R.A, Vaughan, I.P., Bell, J.R., Bohan, D.A, & Symondson, W.O.C.
  (2010) Prey choice by carabid beetles feeding on an earthworm community
  analysed using species- and lineage-specific PCR primers. \emph{Molecular
  Ecology}, \strong{19}, 1721--1732.

  Davey, J.S., Vaughan, I.P., King, R.A., Bell, J.R., Bohan, D.A.,
  Bruford, M.W., Holland, J.M. & Symondson, W.O.C. (2013) Intraguild
  predation in winter wheat: prey choice by a common epigeal carabid
  consuming spiders. \emph{Journal of Applied Ecology}, \strong{50},
  271--279.

  Vaughan, I.P., Gotelli, N.J., Memmott, J., Pearson, C.E.,
  Woodward, G. and Symondson, W.O.C. (2017) econullnetr: an R package using null
  models to analyse the structure of ecological networks and identify
  resource selection. \emph{Methods in Ecology and Evolution}, in press.
}
\seealso{
\code{\link{test_interactions}}, \code{\link{plot_preferences}}
}

