% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.R
\name{ec_proximity}
\alias{ec_proximity}
\title{Proximity}
\usage{
ec_proximity(rca = NULL, c = "country", p = "product", v = "value",
  d = NULL, d_c = "country", d_v = "value", u = NULL,
  u_p = "product", u_v = "value", tbl = FALSE, compute = "both")
}
\arguments{
\item{rca}{matrix or tibble/data.frame in long format (e.g. the output of
revealed_comparative_advantage()). If it is a matrix it must be a zero/one
matrix with countries in the row names and ps in the column names.
If rca is a tibble/data.frame it must contain the columns c (character/
factor), p (character/factor) and discrete RCA (integer)}

\item{c}{string to indicate the column that contains exporting
countries (default set to "country" that is the output of
revealed_comparative_advantage(), applies only if rca is a data.frame)}

\item{p}{string to indicate the column that contains exported ps
(default set to "product" that is the output of
revealed_comparative_advantage(), applies only if rca is a data.frame)}

\item{v}{string to indicate the column that contains RCA vs (default
set to "value" that is the output of revealed_comparative_advantage(),
applies only if rca is a data.frame)}

\item{d}{numeric vector or tibble/data.frame containing diversity
measures (e.g. \code{d} from \code{complexity_measures()})}

\item{d_c}{string to indicate the column that contains
countries in "diversity" (default set to "country" that is the output of
economic_complexity_measures())}

\item{d_v}{string to indicate the column that contains
values in "diversity" (default set to "value" that is the output of
economic_complexity_measures())}

\item{u}{numeric vector or tibble/data.frame containing ubiquity
measures (e.g. \code{u} from \code{complexity_measures()})}

\item{u_p}{string to indicate the column that contains
products in "ubiquity" (default set to "product" that is the output of
economic_complexity_measures())}

\item{u_v}{string to indicate the column that contains
values in "ubiquity" (default set to "value" that is the output of
economic_complexity_measures())}

\item{tbl}{when set to TRUE the output will be a tibble instead of a
matrix (default set to FALSE)}

\item{compute}{by default set to "both", it can also be "country" or
"product"}
}
\description{
Proximity
}
\examples{
ec_proximity(
  rca = ec_output_demo$rca_tbl,
  d = ec_output_demo$complexity_measures_tbl$diversity,
  u = ec_output_demo$complexity_measures_tbl$ubiquity,
  tbl = TRUE
)

}
\references{
For more information on proximity and its applications see:

\insertRef{atlas2014}{economiccomplexity}
}
\keyword{functions}
