% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.plugjs}
\alias{ec.plugjs}
\title{Install Javascript plugin from URL source}
\usage{
ec.plugjs(wt = NULL, source = NULL, ask = FALSE)
}
\arguments{
\item{wt}{A widget to add dependency to, see \code{\link[htmlwidgets]{createWidget}}}

\item{source}{URL or file:// of an uninstalled Javascript plugin, \cr
or name of an installed plugin file with suffix '.js'. Default is NULL.}

\item{ask}{Whether to ask the user to download source if missing. Default is FALSE}
}
\value{
A widget with JS dependency added if successful, otherwise input wt
}
\description{
Install Javascript plugin from URL source
}
\details{
When \emph{source} is URL, the plugin file is installed with a popup prompt to the user.\cr
When \emph{source} is just a file name (xxx.js), it is assumed installed and only a dependency is added. The latter option is for internal usage by echarty.
}
\examples{
# import map plugin and display two (lon,lat) locations
p <- ec.init() \%>\% ec.plugjs(
  'https://raw.githubusercontent.com/apache/echarts/master/test/data/map/js/china-contour.js')
p$x$opts <- list(
  geo = list(map='china-contour', roam=TRUE),
  legend = list(data = list(list(name = 'Geo'))),
  series = list(list( name = 'Geo',
    type = 'scatter', coordinateSystem = 'geo',
    symbolSize = 9, itemStyle = list(color='red'),
    data = list(list(value=c(113, 40)), list(value=c(118, 39))) ))
)
p

}
