% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{e_capture}
\alias{e_capture}
\title{Capture event}
\usage{
e_capture(e, event)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{event}{An event name from the \href{https://echarts.apache.org/en/api.html#events}{event documentation}.}
}
\description{
Add an event capture.
}
\details{
Many events can be captured, however not all are integrated, you can pass one that is not implemented with this function.
}
\examples{
\dontrun{
# add datazoom
library(shiny)

ui <- fluidPage(
  echarts4rOutput("chart"),
  verbatimTextOutput("zoom")
)

server <- function(input, output) {
  output$chart <- renderEcharts4r({
    mtcars |>
      e_charts(mpg) |>
      e_scatter(qsec) |>
      e_datazoom() |>
      e_capture("datazoom")
  })

  output$zoom <- renderPrint({
    input$chart_datazoom
  })
}

if (interactive()) {
  shinyApp(ui, server)
}
}

}
