% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic.R
\name{e_graphic_g}
\alias{e_graphic_g}
\alias{e_group_g}
\alias{e_image_g}
\alias{e_text_g}
\alias{e_rect_g}
\alias{e_circle_g}
\alias{e_ring_g}
\alias{e_sector_g}
\alias{e_arc_g}
\alias{e_polygon_g}
\alias{e_polyline_g}
\alias{e_line_g}
\alias{e_bezier_curve_g}
\title{Graphic}
\usage{
e_graphic_g(e, ...)

e_group_g(e, ...)

e_image_g(e, ...)

e_text_g(e, ...)

e_rect_g(e, ...)

e_circle_g(e, ...)

e_ring_g(e, ...)

e_sector_g(e, ...)

e_arc_g(e, ...)

e_polygon_g(e, ...)

e_polyline_g(e, ...)

e_line_g(e, ...)

e_bezier_curve_g(e, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Low level API to define graphic elements.
}
\note{
Some elements, i.e.: \code{e_image_g} may not display in the RStudio browwser but will work fine in your browser, R markdown documents and Shiny applications.
}
\section{Functions}{

\itemize{
  \item{\code{e_graphic_g} to initialise graphics, entirely optional.}
  \item{\code{e_group_g} to create group, the children of which will share attributes.}
  \item{\code{e_image_g} to a png or jpg image.}
  \item{\code{e_text_g} to add text.}
  \item{\code{e_rect_g} to add a rectangle.}
  \item{\code{e_circle_g} to add a circle.}
  \item{\code{e_ring_g} to add a ring.}
  \item{\code{e_sector_g}}
  \item{\code{e_arc_g} to create an arc.}
  \item{\code{e_polygon_g} to create a polygon.}
  \item{\code{e_polyline_g} to create a polyline.}
  \item{\code{e_line_g} to draw a line.}
  \item{\code{e_bezier_curve_g} to draw a quadratic bezier curve or cubic bezier curve.}
}
}

\examples{
# may not work in RStudio viewer
# Open in browser
cars \%>\% 
  e_charts(speed) \%>\% 
  e_scatter(dist) \%>\%
  e_image_g(
    right = 20,
    top = 20,
    z = -999,
    style = list(
      image = "https://www.r-project.org/logo/Rlogo.png",
      width = 150,
      height = 150,
      opacity = .6
    )
  )

}
\seealso{
\href{https://echarts.apache.org/en/option.html#graphic}{official documentation}
}
