% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{e_dispatch_action_p}
\alias{e_dispatch_action_p}
\title{Dispatch Action}
\usage{
e_dispatch_action_p(proxy, type, ...)
}
\arguments{
\item{proxy}{An echarts4r proxy as returned by \code{\link{echarts4rProxy}}.}

\item{type}{Type of action to dispatch, i.e.: \code{highlight}.}

\item{...}{Named options.}
}
\description{
Create your own proxies, essentially a wrapper around the 
\href{https://echarts.apache.org/en/api.html#action}{action API}.
}
\examples{
\dontrun{

  library(shiny)

  ui <- fluidPage(
    fluidRow(
      column(8, echarts4rOutput("chart")),
      column(4, actionButton("zoom", "Zoom"))
    )
  )
  
  server <- function(input, output, session){
  
    output$chart <- renderEcharts4r({
      cars \%>\% 
        e_charts(speed) \%>\% 
        e_scatter(dist) \%>\% 
        e_datazoom()
    })
    
    observe({
      req(input$zoom)
      
      echarts4rProxy("chart") \%>\% 
        e_dispatch_action_p("dataZoom", startValue = 1, endValue = 10)
    })
  
  }
  
  shinyApp(ui, server)

}

}
