% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-ogf-method.R
\name{ecld.ogf}
\alias{ecld.ogf}
\alias{ecld.ogf_quartic}
\alias{ecld.ogf_integrate}
\alias{ecld.ogf_gamma}
\alias{ecld.ogf_imnt_sum}
\alias{ecld.ogf_log_slope}
\title{Option generating function (OGF) of ecld}
\usage{
ecld.ogf(object, k, otype = "c", RN = TRUE)

ecld.ogf_quartic(object, k, otype = "c", RN = TRUE)

ecld.ogf_integrate(object, k, otype = "c", RN = TRUE)

ecld.ogf_gamma(object, k, otype = "c", RN = TRUE)

ecld.ogf_imnt_sum(object, k, order, otype = "c", RN = TRUE)

ecld.ogf_log_slope(object, k, otype = "c", RN = TRUE)
}
\arguments{
\item{object}{an object of ecld class}

\item{k}{a numeric vector of log-strike}

\item{otype}{character, specifying option type:
\code{c} (default) or \code{p}.}

\item{RN}{logical, use risk-neutral assumption for \code{mu_D}}

\item{order}{numeric, order of the moment to be computed}
}
\value{
The state price of option
}
\description{
The analytic solutions for OGF of ecld, if available.
Note that, by default, risk neutrality is honored. However, you must note that
when fitting market data, this is usually not true. It is also more preferable
that input object already contains mu_D. It is more consistent and saves time.
}
\examples{
ld <- ecld(sigma=0.01*ecd.mp1)
k <- seq(-0.1, 0.1, by=0.05)
ecld.ogf(ld,k)
}
\author{
Stephen H-T. Lihn
}
\keyword{ogf}
