% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-ogf-method.R
\name{ecd.ogf}
\alias{ecd.ogf}
\title{Option generating function of ecd}
\usage{
ecd.ogf(object, k, otype = "c", unit.sigma = FALSE, verbose = FALSE)
}
\arguments{
\item{object}{an object of ecd class}

\item{k}{a numeric vector of log-strike}

\item{otype}{character, specifying option type: \code{c} or \code{p}.}

\item{unit.sigma}{logical, transforming to unit sigma to achieve greater stability.}

\item{verbose}{logical, display timing information, for debugging purpose.}
}
\value{
The option price normalized by underlying
}
\description{
Option generating function (OGF) of ecd.
For call, it is integration of \eqn{(e^z-e^k) P(z)} for \code{z} from \code{k} to \code{Inf}.
For put, it is integration of \eqn{(e^k-e^z) P(z)} for \code{z} from \code{-Inf} to \code{k}.
}
\examples{
d <- ecd(0, 0, sigma=0.01)
k <- seq(-0.1, 0.1, by=0.01)
ecd.ogf(d, k, "c")
}
\author{
Stephen H. Lihn
}
\keyword{option}

