% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one2multi.R
\name{is_one2multi}
\alias{is_one2multi}
\alias{is_one2one}
\alias{is_multi2multi}
\alias{cols_one2multi}
\alias{select_one2multi}
\alias{unique_length}
\title{Check cols one-to-one, or one-to-multi in data.frame}
\usage{
is_one2multi(df, col_1, col_2)

is_one2one(df, col_1, col_2)

is_multi2multi(df, col_1, col_2)

cols_one2multi(df, col, inculde_self = TRUE)

select_one2multi(df, col, inculde_self = TRUE)

unique_length(df, col_1, col_2)
}
\arguments{
\item{df}{A data.frame}

\item{col, col_1, col_2}{A string to specify a colname.}

\item{inculde_self}{A logical.
If TRUE, return value including input col.}
}
\value{
is_one2multi(), is_one2one(), is_multi2multi()  return a logical.
cols_one2multi() returns strings of colnames
that has one2multi relation to input col.
unique_length() returns a list.
}
\description{
Check cols one-to-one, or one-to-multi in data.frame
}
\examples{
df <- tibble::tibble(
  x     = rep(letters[1:6], each = 1),
  x_grp = rep(letters[1:3], each = 2),
  y     = rep(LETTERS[1:3], each = 2),
  y_grp = rep(LETTERS[1:3], each = 2),
  z      = rep(LETTERS[1:3], each = 2),
  z_grp  = rep(LETTERS[1:3], times = 2))

unique_length(df, "x", "x_grp")

is_one2one(df, "x", "x_grp")
is_one2one(df, "y", "y_grp")
is_one2one(df, "z", "z_grp")

}
