% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_construction.R
\name{draw_layer_construction}
\alias{draw_layer_construction}
\alias{add_mid_p_bin_w}
\alias{mid_point}
\alias{bin_width}
\title{Draw layer construction plot}
\usage{
draw_layer_construction(
  df,
  stand = "stand",
  height = "height",
  cover = "cover",
  group = "",
  ...
)

add_mid_p_bin_w(df, height = "height")

mid_point(x)

bin_width(x)
}
\arguments{
\item{df}{A dataframe including columns: stand, layer height and cover.
Optional column: stand group.}

\item{stand, height, cover, group}{A string to specify stand, height, cover, group column.}

\item{...}{Extra arguments for geom_bar().}

\item{x}{A numeric vector.}
}
\value{
draw_layer_construction() returns gg object,
add_mid_p_bin_w() returns dataframe including mid_point and
bin_width columns.
mid_point() and bin_width() return a numeric vector.
}
\description{
Draw layer construction plot

Add mid point and bin width of layer heights.

Compute mid point of layer heights.

Compute bin width of layer heights.
}
\examples{
library(dplyr)
n <- 10
height_max <- 20
ly_list    <- c("B", "S", "K")
st_list    <- LETTERS[1]
sp_list    <- letters[1:9]
st_group   <- NULL
sp_group   <- rep(letters[24:26], 3)
cover_list <- 2^(0:4)
df <- gen_example(n = n, use_layer = TRUE,
                  height_max = height_max, ly_list = ly_list,
                  st_list  = st_list,  sp_list  = sp_list,
                  st_group = st_group, sp_group = sp_group,
                  cover_list = cover_list)

# select stand and summarise by sp_group
df \%>\%
  dplyr::group_by(height, sp_group) \%>\%
  dplyr::summarise(cover = sum(cover), .groups = "drop") \%>\%
  draw_layer_construction(group = "sp_group", colour = "white")

}
