% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_pis}
\alias{load_pis}
\title{Load eBird Status and Trends predictor importance data}
\usage{
load_pis(path, ext, return_sf = FALSE)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent to filter the
data to. The spatial component of the extent object must be provided in
unprojected, latitude-longitude coordinates.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
Data frame, or \link{sf} object if \code{return_sf = TRUE}, containing PI
estimates for each stixel for both the occurrence and relative abundance
models. The data are provided in a 'wide' format, with each row
corresponding to the PI estimates for a give stixel for the occurrence
count model, and the relative importance of each predictor in columns.
Stixels are identified by a unique \code{stixel_id}, the centroid of the stixel
in space and time is specified by the \code{lat}, \code{lon}, and \code{date} column,
which expresses the day of year as a value from 0-1.
}
\description{
Loads the predictor importance (PI) data from the pi-pd.db sqlite database.
PI estimates are provided for each stixel over which a model was run and are
identified by a unique stixel ID in addition to the coordinates of the stixel
centroid. PI estimates are for the occurrence model only.
}
\examples{
\donttest{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load predictor importance
pis <- load_pis(path)

# plot the top 15 predictor importances
# define a spatiotemporal extent to plot data from
bb_vec <- c(xmin = -86.6, xmax = -82.2, ymin = 41.5, ymax = 43.5)
e <- ebirdst_extent(bb_vec, t = c("05-01", "05-31"))
plot_pis(pis, ext = e, n_top_pred = 15, by_cover_class = TRUE)
}
}
