% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_raw.R
\name{import_raw}
\alias{import_raw}
\title{Import R data frame with explicit meta data sheets}
\usage{
import_raw(df, varLabels, valLabels = NULL, checkVarNames = TRUE)
}
\arguments{
\item{df}{A \code{data.frame}.}

\item{varLabels}{A \code{data.frame} containing the variable labels. All variables in the data have to have exactly one column in this data.frame.}

\item{valLabels}{A \code{data.frame} containing the value labels. All referenced variables have to appear in the data, but not all variables in the data have to receive value labels. Can be omitted.}

\item{checkVarNames}{Should variable names be checked for violations of \code{SQLite} and \code{R} naming rules?}
}
\value{
Returns a list with the actual data \code{dat} and with all meta information in long format \code{labels}.
}
\description{
Function to import a \code{data.frame} object for use in \code{eatGADS} while adding explicit variable and value meta information through
separate \code{data.frames}.
}
\details{
The argument \code{varLables} has to contain exactly two variables, namely \code{varName} and \code{varLabel}. \code{valLables} has
to contain exactly four variables, namely \code{varName}, \code{value}, \code{valLabel} and \code{missings}. The column \code{value}
can only contain numerical values. The column \code{missings} can only contain the values \code{"valid"} and \code{"miss"}.
Variables of type \code{factor} are not supported in any of the \code{data.frames}.
}
\examples{
dat <- data.frame(ID = 1:5, grade = c(1, 1, 2, 3, 1))
varLabels <- data.frame(varName = c("ID", "grade"),
                       varLabel = c("Person Identifier", "School grade Math"),
                       stringsAsFactors = FALSE)
valLabels <- data.frame(varName = c("grade", "grade", "grade"),
                       value = c(1, 2, 3),
                       valLabel = c("very good", "good", "sufficient"),
                       missings = c("valid", "valid", "valid"),
                       stringsAsFactors = FALSE)

gads <- import_raw(df = dat, varLabels = varLabels, valLabels = valLabels, checkVarNames = FALSE)

# Inspect Meta data
extractMeta(gads)

# Extract Data
dat <- extractData(gads, convertLabels = "character")

}
