% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMissings.R
\name{checkMissings}
\alias{checkMissings}
\title{Check and Adjust Missing Coding}
\usage{
checkMissings(
  GADSdat,
  missingLabel = "missing",
  addMissingCode = TRUE,
  addMissingLabel = FALSE
)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{missingLabel}{Single string indicating how missing labels are commonly named in the value labels.}

\item{addMissingCode}{If \code{TRUE}, missing codes are added according to occurrence of \code{"missingLabel"} in \code{"valLabel"}.}

\item{addMissingLabel}{If \code{TRUE}, \code{"generic missing"} is added according to occurrence of \code{"mis"} in \code{"missings"}. As often various value labels for missings are used, this argument should be used with great care.}
}
\value{
Returns a \code{GADSdat} object.
}
\description{
Function to check if missings are coded and labeled correctly in a \code{GADSdat} object.
}
\details{
The function compares value labels \code{"valLabels"} and missing codes \code{"missings"} of a \code{GADSdat} object and its
meta data information. Mismatches are reported and can be automatically adjusted.
}
\examples{
# Change example data set (create a value label with incorrect missing code)
pisa2 <- changeValLabels(pisa, varName = "computer_age",
                        value = 5, valLabel = "missing: No computer use")

pisa3 <- checkMissings(pisa2)

}
