% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemValuesConstraint.R
\name{itemValuesConstraint}
\alias{itemValuesConstraint}
\title{Create single value constraints.}
\usage{
itemValuesConstraint(
  nForms,
  nItems,
  itemValues,
  operator = c("<=", "=", ">="),
  targetValue
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{operator}{A character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValue}{the target test form value}
}
\value{
A sparse matrix.
}
\description{
Create constraints related to an item parameter/value. That is, the created
constraints assure that the sum of the item values (\code{itemValues}) per test form is either
(a) smaller than or equal to (\code{operator = "<="}), (b) equal to
(\code{operator = "="}), or (c) greater than or equal to (\code{operator = ">="})
the chosen \code{targetValue}.
}
\examples{
## constraints to make sure that the sum of the item values (1:10) is between
## 4 and 6
rbind(
  itemValuesConstraint(2, 10, 1:10, operator = ">=", targetValue = 4),
  itemValuesConstraint(2, 10, 1:10, operator = "<=", targetValue = 6))

}
