#' PISA score and social index by country
#'
#' A dataset containing the PISA score in mathematics, reading and science and 13 variables related to the social index by country for 2018.
#'
#' @format A data frame with 72 rows and 18 variables:
#' \describe{
#'   \item{Country}{Country name}
#'   \item{Continent}{Country continent}
#'   \item{S_PISA}{PISA score in Science}
#'   \item{R_PISA}{PISA score in Reading}
#'   \item{M_PISA}{PISA score in Mathematics}
#'   \item{NBMC}{Nutritional and Basic Medical Care}
#'   \item{WS}{Water and Sanitation}
#'   \item{S}{Shelter}
#'   \item{PS}{Personal Safety}
#'   \item{ABK}{Access to Basic Knowledge}
#'   \item{AIC}{Access to Information and Communication}
#'   \item{HW}{Health and Wellness}
#'   \item{EQ}{Environmental Quality}
#'   \item{PR}{Personal Rights}
#'   \item{PFC}{Personal Freedom and Choice}
#'   \item{I}{Inclusiveness}
#'   \item{AAE}{Access to Advanced Education}
#'   \item{GDP_PPP}{Gross Domestic Product per capita adjusted by purchasing power parity}
#' }
#'
#' @source \url{https://www.socialprogress.org/}
#' @source \url{https://www.oecd.org/pisa/Combined_Executive_Summaries_PISA_2018.pdf}
"PISAindex"