% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{marginalize}
\alias{marginalize}
\title{Helper function to sum over nuisance variables}
\usage{
marginalize(data, ...)
}
\arguments{
\item{data}{The output of \code{\link[=get_dec_table]{get_dec_table()}} or \code{\link[=get_acs_table]{get_acs_table()}}}

\item{...}{The variables of interest, which will be kept. Remaining variables
will be marginalized out.}
}
\value{
A new data frame that has had \code{\link[=group_by]{group_by()}} and \code{\link[=summarize]{summarize()}} applied.
}
\description{
For ACS data, margins of error will be updated appropriately, using
\code{\link[tidycensus:moe_sum]{tidycensus::moe_sum()}}.
}
\examples{
\dontrun{
d_cens = get_acs_table("state", "B25042")
marginalize(d_cens, bedrooms)
}
}
