\name{NcReadVarNames}
\alias{NcReadVarNames}
\title{
Read Names of Variables in a NetCDF File
}
\description{
Reads the names of the variables in a NetCDF file and returns them as a vector of character strings.
}
\usage{
NcReadVarNames(file_to_read)
}
\arguments{
  \item{file_to_read}{
Path to the file to be read or a NetCDF object as returned by \code{easyNCDF::NcOpen} or \code{ncdf4::nc_open}.
  }
}
\value{
Vector of character strings with the names of the variables in the NetCDF file.
}
\examples{
# Create an array from R
file_path <- tempfile(fileext = '.nc')
a <- array(1:9, dim = c(member = 3, time = 3))
# Store into a NetCDF twice, as two different variables
ArrayToNc(list(var_1 = a, var_2 = a + 1), file_path)
# Read the dimensions and variables in the created file
fnc <- NcOpen(file_path)
fnc_dims <- NcReadDims(fnc)
var_names <- NcReadVarNames(fnc)
# Read the two variables from the file into an R array
a_from_file <- NcToArray(fnc, vars_to_read = var_names)
NcClose(fnc)
# Check the obtained array matches the original array
print(a)
print(a_from_file[1, , ])
}
\author{
History:\cr
0.0  -  2017-03  (N. Manubens, \email{nicolau.manubens at bsc.es})  -  Original code
}
\keyword{datagen}
