% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ea_funcs.R
\name{predict.eadrm}
\alias{predict.eadrm}
\title{Makes predictions from an eadrm object}
\usage{
\method{predict}{eadrm}(object, newx = object$xvals, ci.obj = NULL, ...)
}
\arguments{
\item{object}{Fitted model of class eadrm.}

\item{newx}{Vector of new concentration values at which predictions
are to be made. Defaults to the concentration values that were used
to fit the model.}

\item{ci.obj}{Output from eadrm.ci that is used to compute
confidence intervals. Defaults to NULL, in which case no confidence
intervals are computed.}

\item{...}{Additional arguments passed to or from other methods.
Currently ignored.}
}
\value{
If no confidence intervals are requested, a vector
of predicted responses for each concentration in newx is returned.
Otherwise returns a list of three vectors yhat.med, yhat.l95, and
yhat.u95, which correspond to the median predicted response and
lower/upper 95\% confidence bounds for each concentration in newx.
}
\description{
Similar to other predict methods, this function predicts fitted
values (and optionally confidence intervals) for a eadrm object.
}
\examples{
ea.fit <- eadrm(CarboA$y, CarboA$x)
predict(ea.fit)
}
\seealso{
\code{\link{eadrm}}, \code{\link{eadrm.ci}}
}
