% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{is_single_numeric}
\alias{is_single_numeric}
\title{Check whether a value is a single numeric}
\usage{
is_single_numeric(x)
}
\arguments{
\item{x}{A value to be tested}
}
\description{
Check whether a value is a single numeric
}
\examples{
\dontrun{
library(assertthat)
assert_that(is_single_numeric(1))
# TRUE

assert_that(is_single_numeric(Inf))
# TRUE

assert_that(is_single_numeric(1.6))
# TRUE

assert_that(is_single_numeric(NA))
# Error: NA is not a single numeric value

assert_that(is_single_numeric(1:6))
# Error: 1:6 is not a single numeric value

assert_that(is_single_numeric("pie"))
# Error: "pie" is not a single numeric value
}
}
