% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jump.R
\name{nu}
\alias{nu}
\alias{nu.bayesCox}
\title{Generic function for the latent variance}
\usage{
nu(object, ...)

\method{nu}{bayesCox}(object, ...)
}
\arguments{
\item{object}{An object returned by function \code{bayesCox}.}

\item{...}{Other arguments.}
}
\value{
A data.frame with 4 columns \code{("Iter", "Model", "Cov",
"Value")}, where \code{Iter} is the iteration number; \code{Model} and
\code{Cov} contain the character values of the model type and covariates.
}
\description{
Generic function for the latent variance
}
\section{Methods (by class)}{
\itemize{
\item \code{bayesCox}: Extract Latent Variance from Bayesian Cox Model

Extract latent variance from \code{bayesCox} fitting results, and summarize
them into a data frame. It is applicable when \code{model="TimeVarying"} or
\code{model="Dynamic"}, and \code{coef.prior=list(type="HAR1")}.
}}
\examples{
## See the examples in bayesCox.
}
\seealso{
\code{\link{bayesCox}}, and \code{\link{plotNu}}.
}
\keyword{bayesCox}
\keyword{extract}
\keyword{latent}
\keyword{variance}

