% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrGetDerivs.R
\name{plotGCV}
\alias{plotGCV}
\title{A function to evaluate the generalized cross-validation (GCV) values 
associated with derivative estimates via Bsplines at a range of specified 
smoothing parameter (lambda) values}
\usage{
plotGCV(theTimes, norder, roughPenaltyMax, dataMatrix, lowLambda, upLambda,
  lambdaInt, isPlot)
}
\arguments{
\item{theTimes}{The time points at which derivative estimation are requested}

\item{norder}{Order of Bsplines - usually 2 higher than roughPenaltyMax}

\item{roughPenaltyMax}{Penalization order. Usually set to 2 higher than the highest-order derivatives desired}

\item{dataMatrix}{Data of size total number of time points x  total number of subjects}

\item{lowLambda}{Lower limit of lambda values to be tested. Here, lambda is a 
positive smoothing parameter, with larger values resulting in greater smoothing)}

\item{upLambda}{Upper limit of lambda}

\item{lambdaInt}{The interval of lambda values to be tested.}

\item{isPlot}{A binary flag on whether to plot the gcv values (0 = no, 1 = yes)}
}
\value{
A data frame containing:
1. lambda values; 2. edf (effective degrees of freedom); 
3. GCV (Generalized cross-validation value as averaged across units (e.g., subjects))
}
\description{
A function to evaluate the generalized cross-validation (GCV) values 
associated with derivative estimates via Bsplines at a range of specified 
smoothing parameter (lambda) values
}
\references{
Chow, S-M. (2019). Practical Tools and Guidelines for Exploring and Fitting Linear 
and Nonlinear Dynamical Systems Models. Multivariate Behavioral Research. https://www.nihms.nih.gov/pmc/articlerender.fcgi?artid=1520409

Chow, S-M., *Bendezu, J. J., Cole, P. M., & Ram, N. (2016). A Comparison of Two-
Stage Approaches for Fitting Nonlinear Ordinary Differential Equation (ODE) 
Models with Mixed Effects. Multivariate Behavioral Research, 51, 154-184. Doi: 10.1080/00273171.2015.1123138.
}

