% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.loadings}
\alias{prep.loadings}
\title{Recipe function to quickly create factor loadings}
\usage{
prep.loadings(map, params = NULL, idvar, exo.names = character(0),
  intercept = FALSE)
}
\arguments{
\item{map}{list giving how the latent variables map onto the observed variables}

\item{params}{parameter numbers}

\item{idvar}{names of the variables used to identify the factors}

\item{exo.names}{names of the exogenous covariates}

\item{intercept}{logical. Whether to include freely esimated intercepts}
}
\description{
Recipe function to quickly create factor loadings
}
\details{
The default pattern for 'idvar' is to fix the first factor loading 
for each factor to one.  The variable names listed in 'idvar' have 
their factor loadings fixed to one.  However, if the names of the 
latent variables are used for 'idvar', then all the factor loadings
will be freely estimated and you should fix the factor variances 
in the noise part of the model (e.g. \code{\link{prep.noise}}).

This function does not have the full set of features possible in 
the dynr package. In particular, it does not have any regime-swtiching.
Covariates can be included with the \code{exo.names} argument, but
all covariate effects are freely estimated and the starting values
are all zero.  Likewise, intercepts can be included with the \code{intercept}
logical argument, but all intercept terms are freely estimated with 
zero as the starting value.
For complete functionality use \code{\link{prep.measurement}}.
}

