% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimred_landmark_mds.R
\name{dimred_landmark_mds}
\alias{dimred_landmark_mds}
\title{Landmark MDS}
\usage{
dimred_landmark_mds(x, ndim = 2, distance_method = c("pearson",
  "spearman", "cosine", "euclidean", "manhattan"), num_landmarks = 500)
}
\arguments{
\item{x}{Log transformed expression data, with rows as cells and columns as features}

\item{ndim}{The number of dimensions}

\item{distance_method}{The name of the distance metric, see \link[dynutils:calculate_distance]{dynutils::calculate_distance}}

\item{num_landmarks}{The number of landmarks to use,}
}
\description{
Landmark MDS
}
\examples{
library(Matrix)
dataset <- abs(Matrix::rsparsematrix(100, 100, .5))
dimred_landmark_mds(dataset, ndim = 3)
}
