% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamite-package.R
\docType{data}
\name{multichannel_example_fit}
\alias{multichannel_example_fit}
\title{Model Fit for the Simulated Multivariate Panel Data}
\format{
A \code{dynamitefit} object.
}
\source{
Script in
\url{https://github.com/ropensci/dynamite/blob/main/data-raw/multichannel_example_fit.R}
}
\usage{
multichannel_example_fit
}
\description{
A \code{dynamitefit} object obtained by running \code{dynamite} on the
\code{multichannel_example} dataset as
\preformatted{
set.seed(1)
library(dynamite)
f <- obs(g ~ lag(g) + lag(logp), family = "gaussian") +
  obs(p ~ lag(g) + lag(logp) + lag(b), family = "poisson") +
  obs(b ~ lag(b) * lag(logp) + lag(b) * lag(g), family = "bernoulli") +
  aux(numeric(logp) ~ log(p + 1))
multichannel_example_fit <- dynamite(
  f,
  data = multichannel_example,
  time = "time",
  group = "id",
  chains = 1,
  cores = 1,
  iter = 2000,
  warmup = 1000,
  init = 0,
  refresh = 0,
  thin = 5,
  save_warmup = FALSE
)
}
Note the small number of samples due to size restrictions on CRAN.
}
\seealso{
Example models
\code{\link{categorical_example}},
\code{\link{categorical_example_fit}},
\code{\link{gaussian_example}},
\code{\link{gaussian_example_fit}},
\code{\link{gaussian_simulation_fit}},
\code{\link{multichannel_example}}
}
\concept{examples}
\keyword{datasets}
