/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import org.jvnet.substance.color.HueShiftColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceWrapperTheme;

public class SubstanceHueShiftTheme
extends SubstanceWrapperTheme {
    private double hueShiftFactor;

    SubstanceHueShiftTheme(SubstanceTheme substanceTheme, double hueShiftFactor) {
        super(substanceTheme, new HueShiftColorScheme(substanceTheme.getColorScheme(), hueShiftFactor), "Hue-shift " + substanceTheme.getDisplayName() + " " + (int)(100.0 * hueShiftFactor) + "%", substanceTheme.getKind());
        this.hueShiftFactor = hueShiftFactor;
    }

    public SubstanceTheme getDefaultTheme() {
        if (this.defaultTheme == null) {
            this.defaultTheme = this.originalTheme.getDefaultTheme().hueShift(this.hueShiftFactor);
        }
        return this.defaultTheme;
    }

    public SubstanceTheme getDisabledTheme() {
        if (this.disabledTheme == null) {
            this.disabledTheme = this.originalTheme.getDisabledTheme().hueShift(this.hueShiftFactor);
        }
        return this.disabledTheme;
    }

    public SubstanceTheme hueShift(double hueShiftFactor) {
        if ((hueShiftFactor += this.hueShiftFactor) != 0.0) {
            return this.getOriginalTheme().hueShift(hueShiftFactor);
        }
        return this.getOriginalTheme();
    }
}

