/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.JASHist;
import jas.hist.ScatterDataManager;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.Legend;

final class DoubleScatterDataManager
extends ScatterDataManager {
    private DoubleAxis xAxisType;

    DoubleScatterDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da, l, stats);
        DoubleAxis yAxisType;
        if (this.xm.getType() instanceof DoubleAxis) {
            this.xAxisType = (DoubleAxis)this.xm.getType();
        } else {
            this.xAxisType = new DoubleAxis();
            this.xm.setType(this.xAxisType);
        }
        if (this.ym[0].getType() instanceof DoubleAxis) {
            yAxisType = (DoubleAxis)this.ym[0].getType();
        } else {
            yAxisType = new DoubleAxis();
            this.ym[0].setType(yAxisType);
        }
        this.xm.setDataManager(this, false, this.xAxisType);
        this.ym[0].setDataManager(this, false, yAxisType);
    }

    protected final void calcXMinMax(double x1, double x2) {
        double oldXMin = this.xAxisType.getPlotMin();
        double oldXMax = this.xAxisType.getPlotMax();
        if (x1 < oldXMin || x2 > oldXMax || (x2 - x1) / (oldXMax - oldXMin) < 0.75) {
            this.xAxisType.setMin(x1);
            this.xAxisType.setMax(x2);
            this.xm.invalidate();
        }
    }
}

