/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.Continue;
import don.ContinueAnalysee;
import don.DonneeID;
import don.Individu;
import don.Modalite;
import don.ModaliteMoyenne;
import don.Qualifiable;
import don.QualifiableRepresentable;
import don.Variable;
import don.Verifiable;
import exceptions.ExceptionIntegrite;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nominale
implements Serializable,
Variable,
Verifiable,
Qualifiable {
    private static final long serialVersionUID = 6606347683598577331L;
    private Vector<ModaliteMoyenne> m_modalites;
    private String m_nom;
    private HashMap<Modalite, Double> val_descMod;
    private HashMap<ContinueAnalysee, Double> val_descCont;
    private HashMap<Nominale, Double> val_descNom;

    public Nominale(String nom) {
        this.m_nom = nom;
        this.m_modalites = new Vector();
        this.val_descMod = new HashMap();
        this.val_descCont = new HashMap();
        this.val_descNom = new HashMap();
    }

    @Override
    public String getAnnotation() {
        return this.m_nom;
    }

    public void setNom(String nom) {
        this.m_nom = nom;
    }

    public Vector<ModaliteMoyenne> getModalites() {
        return this.m_modalites;
    }

    public void addModaliteMoyenne(ModaliteMoyenne mod) {
        this.m_modalites.add(mod);
        if (mod.getNominale() == null || !mod.getNominale().equals(this)) {
            mod.setNominale(this);
        }
    }

    public int getNbModalites() {
        return this.m_modalites.size();
    }

    public Modalite getModalite(String annot) {
        Modalite mod = null;
        int i = 0;
        while (i < this.m_modalites.size() && mod == null) {
            mod = this.m_modalites.elementAt(i).getModalite(annot);
            ++i;
        }
        return mod;
    }

    public boolean isModActif() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_modalites.size() && !trouve) {
            trouve = this.m_modalites.elementAt(i).isActive();
            ++i;
        }
        return trouve;
    }

    public boolean isModIllus() {
        boolean trouve = false;
        int i = 0;
        while (i < this.m_modalites.size() && !trouve) {
            trouve = !this.m_modalites.elementAt(i).isActive();
            ++i;
        }
        return trouve;
    }

    private int position(Modalite modalite) {
        return this.m_modalites.indexOf(modalite);
    }

    public int getNumModalite(DonneeID don) {
        if (don instanceof Individu) {
            Individu ind = (Individu)don;
            Modalite mod = ind.getModalite(this);
            if (mod != null) {
                return this.position(mod);
            }
            return -1;
        }
        return -1;
    }

    @Override
    public double getDescMod(Modalite mod) {
        Double val = this.val_descMod.get(mod);
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    @Override
    public void setDescMod(Modalite mod, Double vtest) {
        this.val_descMod.put(mod, vtest);
    }

    @Override
    public double getDescCont(ContinueAnalysee cont) {
        Double val = this.val_descCont.get(cont);
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    @Override
    public void setDescCont(ContinueAnalysee cont, Double vtest) {
        this.val_descCont.put(cont, vtest);
    }

    @Override
    public double getDescNom(Nominale nom) {
        Double val = this.val_descNom.get(nom);
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    @Override
    public void setDescNom(Nominale nom, Double vtest) {
        this.val_descNom.put(nom, vtest);
    }

    @Override
    public double getDesc(DonneeID don) {
        if (don instanceof Modalite) {
            return this.getDescMod((Modalite)don);
        }
        if (don instanceof ContinueAnalysee) {
            return this.getDescCont((ContinueAnalysee)don);
        }
        return 0.0;
    }

    @Override
    public double getDesc(Nominale don) {
        return this.getDescNom(don);
    }

    public String toString() {
        String chaine = "---\nvariable nominale : " + this.m_nom + " \nmodalit\u00e9s : \n";
        for (ModaliteMoyenne modaliteMoyenne : this.m_modalites) {
            chaine = String.valueOf(chaine) + modaliteMoyenne.toString() + "\n";
        }
        chaine = String.valueOf(chaine) + "\n v-tests pour les modalites :\n";
        for (QualifiableRepresentable qualifiableRepresentable : this.val_descMod.keySet()) {
            chaine = String.valueOf(chaine) + qualifiableRepresentable.getAnnotation() + " : " + this.val_descMod.get(qualifiableRepresentable) + " | ";
        }
        chaine = String.valueOf(chaine) + "\n v-tests pour les continues :\n";
        for (Continue continue_ : this.val_descCont.keySet()) {
            chaine = String.valueOf(chaine) + continue_.getAnnotation() + " : " + this.val_descCont.get(continue_) + " | ";
        }
        chaine = String.valueOf(chaine) + "\n v-tests pour les nominales :\n";
        for (Nominale nominale : this.val_descNom.keySet()) {
            chaine = String.valueOf(chaine) + nominale.getAnnotation() + " : " + this.val_descNom.get(nominale) + " | ";
        }
        return chaine;
    }

    @Override
    public void verifierIntegrite() throws ExceptionIntegrite {
        if (this.m_nom == null) {
            throw new ExceptionIntegrite("nominale sans nom");
        }
        for (Modalite modalite : this.m_modalites) {
            if (modalite.getNominale() == null) {
                modalite.setNominale(this);
            } else if (modalite.getNominale() != this) {
                throw new ExceptionIntegrite("incoh\u00e9rence nominale - modalit\u00e9");
            }
            modalite.verifierIntegrite();
        }
    }
}

