% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{diff_i}
\alias{diff_i}
\title{Lagged Differences for Integer Values}
\usage{
diff_i(x, lag = 1L)
}
\arguments{
\item{x}{Integer vector.}

\item{lag}{Integer value.}
}
\value{
Integer vector.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[base]{diff}} for calculating lagged differences for an integer 
vector.
}
\examples{
# diff_i is typically much faster than diff
x <- rpois(1000, lambda = 5)
all.equal(diff(x, 2), diff_i(x, 2))
benchmark(diff(x, 2), diff_i(x, 2), replications = 2000)

}
