% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dviSolve.R
\name{dviSolve}
\alias{dviSolve}
\title{A complete pipeline for solving a DVI case}
\usage{
dviSolve(
  dvi,
  threshold = 10000,
  threshold2 = max(1, threshold/10),
  maxIncomp = 2,
  ignoreSex = FALSE,
  limit = 0,
  verbose = TRUE,
  debug = FALSE
)
}
\arguments{
\item{dvi}{A \code{dviData} object.}

\item{threshold}{LR threshold for 'significant' match.}

\item{threshold2}{LR threshold for 'probable' match.}

\item{maxIncomp}{An integer passed onto \code{\link[=findExcluded]{findExcluded()}}. A pairing is
excluded if the number of incompatible markers exceeds this.}

\item{ignoreSex}{A logical, by default FALSE.}

\item{limit}{A number passed onto \code{\link[=findUndisputed]{findUndisputed()}}; only pairwise LR values
above this are considered.}

\item{verbose, debug}{Logicals.}
}
\value{
A data frame.
}
\description{
This wraps several other functions into a complete pipeline for solving a DVI
case.
}
\examples{
dviSolve(example2)
dviSolve(example2, threshold = 5, verbose = FALSE)
}
