% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointDVI.R
\name{summariseDVI}
\alias{summariseDVI}
\title{Summarise a DVI problem}
\usage{
summariseDVI(pm, am, missing, method = NULL, printMax = 10)
}
\arguments{
\item{pm}{A list of singletons.}

\item{am}{A list of pedigrees.}

\item{missing}{Character vector with names of missing persons.}

\item{method}{A character, used by other methods.}

\item{printMax}{A positive integer. Vectors longer than this are truncated.}
}
\value{
No return value, called for side effects.
}
\description{
Prints a summary of a given DVI problem, including the number of victims,
missing persons, reference families and typed reference individuals. This
function primarily exists for being called from \code{jointDVI()} and other
high-level methods, but can also be used on its own.
}
\examples{
pm = planecrash$pm
am = planecrash$am
missing = planecrash$missing

summariseDVI(pm, am, missing)
summariseDVI(pm, am, missing, printMax = 5)

}
